package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;

public class MetaUICheckRuleAction extends MetaBaseScriptAction<MetaUICheckRule> {

	@Override
	public void load(Document document, Element element, MetaUICheckRule meta, int runType) {
		super.load(document, element, meta, runType);
		
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.UICHECKRULE_DESCRIPTION, ""));
		meta.setErrorInfo(DomHelper.readAttr(element, MetaConstants.UICHECKRULE_ERRORINFO, ""));
		meta.setStringID(DomHelper.readAttr(element, MetaConstants.UICHECKRULE_STRINGID, ""));
		meta.setTarget(DomHelper.readAttr(element, MetaConstants.UICHECKRULE_TARGET, ""));
		meta.setDependency(DomHelper.readAttr(element, MetaConstants.UICHECKRULE_DEPENDENCY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaUICheckRule meta, int runType) {
		super.save(document, element, meta, runType);
		
		DomHelper.writeAttr(element, MetaConstants.UICHECKRULE_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.UICHECKRULE_ERRORINFO, meta.getErrorInfo(), "");
		DomHelper.writeAttr(element, MetaConstants.UICHECKRULE_STRINGID, meta.getStringID(), "");
		DomHelper.writeAttr(element, MetaConstants.UICHECKRULE_TARGET, meta.getTarget(), "");
		DomHelper.writeAttr(element, MetaConstants.UICHECKRULE_DEPENDENCY, meta.getDependency(), "");
	}

}
