package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaBody;

/**
 * MetaBodyAction为Body元素在DOM方式保存时的无数据事件定义，这里没有属性要求作存储
 * 
 * @author 王元和
 * 
 */
public class MetaBodyExtAction extends BaseDomAction<MetaBody> {
	@Override
	public void load(Document document, Element element, MetaBody meta,
			int runType) {
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, null)));
		meta.setHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, null)));
		meta.setPopWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.BODY_POPWIDTH, null)));
		meta.setPopHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.BODY_POPHEIGHT, null)));
		meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_HALIGN, null)));
		meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_VALIGN, null)));
		meta.setOverflowX(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_X, null)));
		meta.setOverflowY(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_Y, null)));
		meta.setTopMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPMARGIN, null)));
		meta.setBottomMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, null)));
		meta.setLeftMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, null)));
		meta.setRightMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, null)));
		meta.setProvider(DomHelper.readAttr(element, MetaConstants.BODY_PROVIDER, null));
		meta.setResizable(DomHelper.readBool(element, MetaConstants.BODY_RESIZABLE, null));
		meta.setLazyCompute(DomHelper.readBool(element, MetaConstants.BODY_LAZYCOMPUTE, null));
	}

	@Override
	public void save(Document document, Element element, MetaBody meta,
			int runType) {
	}
}
