package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateRowType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelRowAction extends BaseDomAction<MetaExcelRow> {

	@Override
	public void load(Document document, Element element, MetaExcelRow meta,
			int runType) {
		meta.setHeight(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_HEIGHT, 35));
		meta.setType(ExcelTemplateRowType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_TYPE, ExcelTemplateRowType.STR_Fix)));
		meta.setRowIndex(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_ROWINDEX, -1));
		meta.setTableKey(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_TABLEKEY, ""));
		meta.setGroupDefination(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_GROUPDEFINATION, ""));
		meta.setGroupLevel(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_GROUPLEVEL, 0));
		meta.setGroupPosition(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_GROUPPOSITION, ""));
		meta.setGroupHeadRowCount(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_GROUPHEADROWCOUNT, 0));
		meta.setGroupTailRowCount(DomHelper.readAttr(element, MetaExcelTemplateConstants.ROW_GROUPTAILROWCOUNT, 0));
	}

	@Override
	public void save(Document document, Element element, MetaExcelRow meta,
			int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_HEIGHT, meta.getHeight(), 35);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_TYPE, ExcelTemplateRowType.toString(meta.getType()), ExcelTemplateRowType.STR_Fix);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_ROWINDEX, meta.getRowIndex(), -1);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_GROUPDEFINATION, meta.getGroupDefination(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_GROUPLEVEL, meta.getGroupLevel(), 0);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_GROUPPOSITION, meta.getGroupPosition(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_GROUPHEADROWCOUNT, meta.getGroupHeadRowCount(), 0);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.ROW_GROUPTAILROWCOUNT, meta.getGroupTailRowCount(), 0);
	}
}
