package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DataObjectLoadRightsType;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.def.DictCacheCheckMode;
import com.bokesoft.yigo.common.def.MigrationUpdateStrategyType;
import com.bokesoft.yigo.common.def.RollDataStrategyType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamigration.MetaDMConstants;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;

/**
 * 数据对象载入和保存时的相关动作
 * 
 * @author 李姝
 * @since YES1.0
 */
public class MetaDataObjectAction extends BaseDomAction<MetaDataObject> {

	public void load(Document doc, Element element, MetaDataObject meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setPrimaryType(DataObjectPrimaryType.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_PRIMARYTYPE, DataObjectPrimaryType.STR_VIRTUAL)));
		meta.setSecondaryType(DataObjectSecondaryType.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_SECONDARYTYPE, DataObjectSecondaryType.STR_NORMAL)));
		meta.setMainTableKey(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_PRIMATYTABLEKEY, ""));
		meta.setNoPrefix(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_NOPREFIX, ""));
		meta.setCustomNoPrefix(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_CUSTOMNOPREFIX, ""));
		meta.setQueryColumns(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_QUERYFIELDS, null));
		meta.setDisplayColumns(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_DISPLAYFIELDS, "Code;Name"));
		meta.setDropviewColumns(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_DROPVIEWFIELDS, null));
		meta.setMigrationUpdateStrategy(MigrationUpdateStrategyType.parse((DomHelper.readAttr(element, MetaDMConstants.UPDATE_STRATEGY, MigrationUpdateStrategyType.STR_INSERT_FAST))));
		meta.setIOProvider(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_IOPROVIDER, ""));
		meta.setMaintainDict(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_MAINTAINDICT, true));
		meta.setRelateObjectKey(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_RELATE_OBJECT_KEY, ""));
		meta.setAuthenticate(DomHelper.readAttr(element, MetaConstants.AUTHENTICATE_FLAG, true));
		meta.setZeroPrefix(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_ZERO_PREFIX, 6));
		meta.setForbiddenLoad(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_LOAD, false));
		meta.setForbiddenSave(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_SAVE, false));
		meta.setForbiddenDelete(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_DELETE, false));
		meta.setLoadRightsType(DataObjectLoadRightsType.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_LOAD_RIGHTS_TYPE, DataObjectLoadRightsType.STR_FILTER)));
		meta.setCheckAfterLoad(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_CHECK_AFTER_LOAD, false));
		meta.setMigrationDeltaDBName(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_MIGRATION_DELTA_DBNAME, ""));
		meta.setVersion(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_VERSION, 0));
		meta.setRollDataStrategy(RollDataStrategyType.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_ROLLDATASTRATEGY, RollDataStrategyType.STR_NORMAL)));
		meta.setGlobalRightFilter(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_GLOBALRIGHTFILTER, ""));
		meta.setMaintainSchema(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_MAINTAINSCHEMA, true));
		meta.setExtend(DomHelper.readAttr(element, MetaConstants.FORM_EXTEND, ""));
		meta.setBrowserFormKey(DomHelper.readAttr(element, MetaConstants.FORM_BROWSER_FORM_KEY, null));
		meta.setQueryFormKey(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_QUERY_FORM_KEY, null));
		meta.setDictCacheCheckMode(DictCacheCheckMode.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_DICTCACHECHECKMODE, "")));
	}

	public void save(Document doc, Element element, MetaDataObject meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_PRIMARYTYPE, DataObjectPrimaryType.toString(meta.getPrimaryType()), DataObjectPrimaryType.STR_VIRTUAL);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_SECONDARYTYPE, DataObjectSecondaryType.toString(meta.getSecondaryType()), DataObjectSecondaryType.STR_NORMAL);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_PRIMATYTABLEKEY, meta.getMainTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_NOPREFIX, meta.getNoPrefix(), "");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_CUSTOMNOPREFIX, meta.getCustomNoPrefix(), "");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_QUERYFIELDS, meta.getOriginalQueryColumnsStr(), null);

		String displayColumnsStr = meta.getDisplayColumnsStr();
		if (displayColumnsStr == null || displayColumnsStr.isEmpty()) {
			displayColumnsStr = "Code;Name";
		}
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_DISPLAYFIELDS, displayColumnsStr, "Code;Name");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_DROPVIEWFIELDS, meta.getDropviewColumnsStr(), null);
		DomHelper.writeAttr(element, MetaDMConstants.UPDATE_STRATEGY, MigrationUpdateStrategyType.toString(meta.getMigrationUpdateStrategy()), MigrationUpdateStrategyType.STR_INSERT_FAST);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_IOPROVIDER, meta.getIOProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_MAINTAINDICT, meta.isMaintainDict(), true);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_RELATE_OBJECT_KEY, meta.getRelateObjectKey(), "");
		DomHelper.writeAttr(element, MetaConstants.AUTHENTICATE_FLAG, meta.isAuthenticate(), true);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_ZERO_PREFIX, meta.getZeroPrefix(), 6);
		DomHelper.writeAttr(element, MetaConstants.FORM_EXTEND, meta.getExtend(), "");

		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_LOAD, meta.isForbiddenLoad(), false);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_SAVE, meta.isForbiddenSave(), false);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_DELETE, meta.isForbiddenDelete(), false);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_LOAD_RIGHTS_TYPE, DataObjectLoadRightsType.toString(meta.getLoadRightsType()), DataObjectLoadRightsType.STR_FILTER);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_CHECK_AFTER_LOAD, meta.isCheckAfterLoad(), false);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_MIGRATION_DELTA_DBNAME, meta.getMigrationDeltaDBName(), "");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_VERSION, meta.getVersion(), 0);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_ROLLDATASTRATEGY, RollDataStrategyType.toString(meta.getRollDataStrategy()), RollDataStrategyType.STR_NORMAL);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_GLOBALRIGHTFILTER, meta.getGlobalRightFilter(), "");
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_MAINTAINSCHEMA, meta.isMaintainSchema(), true);
		DomHelper.writeAttr(element, MetaConstants.FORM_BROWSER_FORM_KEY, meta.getBrowserFormKey(), null);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_QUERY_FORM_KEY, meta.getQueryFormKey(), null);
		DomHelper.writeAttr(element, MetaConstants.DATAOBJECT_DICTCACHECHECKMODE, DictCacheCheckMode.toString(meta.getDictCacheCheckMode()), "");
	}
}
