package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ColumnRightsType;
import com.bokesoft.yigo.common.def.DataGroupGranularity;
import com.bokesoft.yigo.common.def.DataSplitType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamigration.DMPeriodGranularityType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;

/**
 * 数据列对象载入和保存时的相关动作
 * 
 * @author lishu
 * @since YES1.0
 */
public class MetaColumnAction extends BaseDomAction<MetaColumn> {

	@Override
	public void load(Document document, Element element, MetaColumn meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		if(element.hasAttribute(MetaConstants.COMMON_DEFAULTVALUE)){
			meta.setDefaultValue(element.getAttribute(MetaConstants.COMMON_DEFAULTVALUE).intern());
		}else{
			meta.setDefaultValue(null);
		}
//		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTVALUE, ""));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTFORMULAVALUE, ""));
		
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COLUMN_DESCRIPTION, ""));
		meta.setPersist(DomHelper.readAttr(element, MetaConstants.COLUMN_PRERSIST, true));
		meta.setDBColumnName(DomHelper.readAttr(element, MetaConstants.COLUMN_DBCOLUMNNAME, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_DATATYPE, "")));
		Integer defaultLength = meta.getDataType() == DataType.STRING ? 255 : null;
		meta.setLength(DomHelper.readInt(element, MetaConstants.COLUMN_DEF_LENGTH, defaultLength));
		Integer defaultPrecision = meta.getDataType() == DataType.NUMERIC ? 16 : null;
		meta.setPrecision(DomHelper.readInt(element, MetaConstants.COLUMN_DEF_PRECISION, defaultPrecision));
		Integer defaultScale = meta.getDataType() == DataType.NUMERIC ? 2 : null;
		meta.setScale(DomHelper.readInt(element, MetaConstants.COLUMN_DEF_SCALE, defaultScale));
		meta.setIsPrimary(DomHelper.readAttr(element, MetaConstants.COLUMN_ISPRIMARY, false));
		meta.setCache(DomHelper.readAttr(element, MetaConstants.COLUMN_CACHE, false));
		meta.setNeedRights(ColumnRightsType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_NEEDRIGHTS, ColumnRightsType.STR_DEFAULT)));
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.COLUMN_ITEMKEY, ""));
		meta.setExpand(DomHelper.readAttr(element, MetaConstants.COLUMN_EXPAND, false));
		meta.setHidden(DomHelper.readAttr(element, MetaConstants.COLUMN_HIDDEN, false));
		meta.setGroupType(DataGroupGranularity.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_GROUPTYPE, "")));
		meta.setSplitType(DataSplitType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_SPLITTYPE, "")));
		meta.setAccessControl(DomHelper.readAttr(element, MetaConstants.COLUMN_ACCESSCONTROL, false));
		meta.setSort(SortType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_SORTTYPE, SortType.STR_None)));
		meta.setIgnoreSave(DomHelper.readAttr(element, MetaConstants.COLUMN_IGNORESAVE, false));
		meta.setIgnoreQuery(DomHelper.readAttr(element, MetaConstants.COLUMN_IGNORE_QUERY, false));
		meta.ignoreModify(DomHelper.readAttr(element, MetaConstants.COLUMN_IGNORE_MODIFY, false));
		meta.setLocalTimeZone(DomHelper.readAttr(element, MetaConstants.COLUMN_LOCALTIMEZONE, false));
		meta.setPeriodGranularity(DMPeriodGranularityType.parse(DomHelper.readAttr(element, MetaConstants.Column_PERIOD_GRANULARITY, "")));
		meta.setPeriodImpl(DomHelper.readAttr(element, MetaConstants.COLUMN_PERIODIMPL, ""));
		meta.setUserTag(DomHelper.readAttr(element, MetaConstants.COLUMN_USERTAG, ""));
		meta.setSupportI18n(DomHelper.readAttr(element, MetaConstants.COLUMN_SUPPORTI18N, false));
		meta.setCodeColumnKey(DomHelper.readAttr(element, MetaConstants.COLUMN_CODECOLUMNKEY, ""));
		meta.setDataElementKey(DomHelper.readAttr(element, MetaConstants.COLUMN_DATAELEMENTKEY, null));
		meta.setRefCol(DomHelper.readAttr(element, MetaConstants.COLUMN_REFCOL, null));
		meta.setRefItemKeyCol(DomHelper.readAttr(element, MetaConstants.COLUMN_REFITEMKEYCOL, null));
		meta.setPrimaryKey(DomHelper.readAttr(element, MetaConstants.COLUMN_PRIMARYKEY, false));
	}

	@Override
	public void save(Document document, Element element, MetaColumn meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		if(meta.getDefaultValue() == null){
			element.removeAttribute(MetaConstants.COMMON_DEFAULTVALUE);
		}else{
			element.setAttribute(MetaConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue());
		}
//		DomHelper.writeAttr(element, MetaConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue(), "");
		
		DomHelper.writeAttr(element, MetaConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_PRERSIST, meta.isPersist(), true);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DBCOLUMNNAME, meta.getDBColumnName(), "");
		
		String dataElementKey = meta.getDataElementKey();
		if(dataElementKey == null || dataElementKey.isEmpty()) {
			DomHelper.writeAttr(element, MetaConstants.COLUMN_DATATYPE, DataType.toString(meta.getDataType()), "");
			int length = meta.getDataType() == DataType.STRING ? meta.getLength() : 0;
			int defaultLength = meta.getDataType() == DataType.STRING ? 255 : 0;
			DomHelper.writeAttr(element, MetaConstants.COLUMN_DEF_LENGTH, length, defaultLength);
			if(meta.getDataType() == DataType.NUMERIC){
				int precision = meta.getDataType() == DataType.NUMERIC ? meta.getPrecision() : 0;
				//int defaultPrecision = meta.getDataType() == DataType.NUMERIC ? 16 : 0;
				element.setAttribute(MetaConstants.COLUMN_DEF_PRECISION, Integer.toString(precision));
				//DomHelper.writeAttr(element, MetaConstants.COLUMN_DEF_PRECISION, precision, defaultPrecision);
				int scale = meta.getDataType() == DataType.NUMERIC ? meta.getScale() : 0;
				//int defaultScale = meta.getDataType() == DataType.NUMERIC ? 4 : 0;
				element.setAttribute(MetaConstants.COLUMN_DEF_SCALE, Integer.toString(scale));
				//DomHelper.writeAttr(element, MetaConstants.COLUMN_DEF_SCALE, scale, defaultScale);
			} else if (meta.getDataType() == DataType.INT || meta.getDataType() == DataType.LONG) {
				// 当原来是numeric类型然后转换成long/int 类型之后，原来的precision、 scale还会保留
				element.removeAttribute(MetaConstants.COLUMN_DEF_PRECISION);
				element.removeAttribute(MetaConstants.COLUMN_DEF_SCALE);
			}	
		}else {
			DomHelper.writeAttr(element, MetaConstants.COLUMN_DATAELEMENTKEY, dataElementKey, null);
		}

		DomHelper.writeAttr(element, MetaConstants.COLUMN_ISPRIMARY, meta.getIsPrimary(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_CACHE, meta.getCache(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_NEEDRIGHTS, ColumnRightsType.toString(meta.getNeedRights()), ColumnRightsType.STR_DEFAULT);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_ITEMKEY, meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_EXPAND, meta.isExpand(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_HIDDEN, meta.isHidden(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_GROUPTYPE, DataGroupGranularity.toString(meta.getGroupType()), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_SPLITTYPE, DataSplitType.toString(meta.getSplitType()), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_ACCESSCONTROL, meta.isAccessControl(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_SORTTYPE, SortType.toString(meta.getSort()), SortType.STR_None);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_IGNORESAVE, meta.isIgnoreSave(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_IGNORE_QUERY, meta.isIgnoreQuery(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_IGNORE_MODIFY, meta.isIgnoreModify(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_LOCALTIMEZONE, meta.isLocalTimeZone(), false);
		DomHelper.writeAttr(element, MetaConstants.Column_PERIOD_GRANULARITY, DMPeriodGranularityType.toString(meta.getPeriodGranularity()), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_PERIODIMPL, meta.getPeriodImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_USERTAG, meta.getUserTag(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_SUPPORTI18N, meta.isSupportI18n(), false);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_CODECOLUMNKEY, meta.getCodeColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_REFCOL, meta.getRefCol(), null);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_REFITEMKEYCOL, meta.getRefItemKeyCol(), null);
		DomHelper.writeAttr(element, MetaConstants.COLUMN_PRIMARYKEY, meta.isPrimaryKey(), false);
	}

}
