package com.bokesoft.yes.meta.persist.dom.datamigration;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamigration.MetaDMConstants;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;

public class MetaDataMigrationAction extends BaseDomAction<MetaDataMigration> {

	@Override
	public void load(Document document, Element element,
			MetaDataMigration meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setSrcDataObjectKey(DomHelper.readAttr(element, MetaDMConstants.SRC_DATAOBJECT_KEY, ""));
		meta.setTgtDataObjectKey(DomHelper.readAttr(element, MetaDMConstants.TGT_DATAOBJECT_KEY, ""));
		meta.setStatusFieldKey(DomHelper.readAttr(element, MetaDMConstants.STATUSKEY, ""));
		meta.setStatusValue(DomHelper.readAttr(element, MetaDMConstants.STATUSVALUE, ""));
		meta.setCondition(DomHelper.readAttr(element, MetaDMConstants.DM_CONDITION, ""));
		meta.setHeadCondition(DomHelper.readAttr(element, MetaDMConstants.DM_HEAD_CONDITION, ""));
		meta.setExtend(DomHelper.readAttr(element, MetaConstants.FORM_EXTEND, ""));
		meta.setFromPartInSql(DomHelper.readAttr(element, MetaDMConstants.RE_MIGRATION_FROM_PART_IN_SQL, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaDataMigration meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaDMConstants.SRC_DATAOBJECT_KEY, meta.getSrcDataObjectKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.TGT_DATAOBJECT_KEY, meta.getTgtDataObjectKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.STATUSKEY, meta.getStatusFieldKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.STATUSVALUE, meta.getStatusValue(), "");
		DomHelper.writeAttr(element, MetaDMConstants.DM_CONDITION, meta.getCondition(), "");
		DomHelper.writeAttr(element, MetaDMConstants.DM_HEAD_CONDITION, meta.getHeadCondition(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_EXTEND, meta.getExtend(), "");
		DomHelper.writeAttr(element, MetaDMConstants.RE_MIGRATION_FROM_PART_IN_SQL, meta.getFromPartInSql(), "");
	}

}
