package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconDisplayMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.commondef.MetaOperation;

/**
 * 窗口操作对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaOperationAction extends BaseDomAction<MetaOperation> {

	@Override
	public void save(Document document, Element element, MetaOperation meta, int runType) {
		
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE, meta.getEnable(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, meta.getEnableDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, meta.getVisibleDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_REFKEY, meta.getRefKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TAG, meta.getTag(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_EXPAND, meta.isExpand(), false);
		DomHelper.writeAttr(element, MetaConstants.OPERATION_EXPAND_SOURCE, meta.getExpandSource(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_SHORTCUTS, meta.getShortCuts(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_CSSCLASS, meta.getCssClass(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_NEEDACCESSLOG, meta.getNeedAccessLog(), false);
		DomHelper.writeAttr(element, MetaConstants.OPERATION_UPLOADFILE, meta.isUploadFile(), false);
		DomHelper.writeAttr(element, MetaConstants.OPERATION_UPLOADTYPE, meta.getUploadType(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON_CODE,meta.getIconCode(), "");
		DomHelper.writeAttr(element, MetaConstants.ICON_DISPLAY_MODE, meta.getDisplayMode() == null ? "": IconDisplayMode.format(meta.getDisplayMode()), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_TCODE, meta.getTCode(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_ACTIVITY, meta.getActivity(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_ISTRANSFER, meta.isTransfer(), null);
	}

	@Override
	public void load(Document document, Element element, MetaOperation meta, int runType) {
		
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, ""));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
		meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, ""));
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, ""));
		meta.setRefKey(DomHelper.readAttr(element, MetaConstants.OPERATION_REFKEY, ""));
		meta.setTag(DomHelper.readAttr(element, MetaConstants.COMMON_TAG, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setExpand(DomHelper.readAttr(element, MetaConstants.OPERATION_EXPAND, false));
		meta.setExpandSource(DomHelper.readAttr(element, MetaConstants.OPERATION_EXPAND_SOURCE, ""));
		meta.setShortCuts(DomHelper.readAttr(element, MetaConstants.OPERATION_SHORTCUTS, ""));
		meta.setCssClass(DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, ""));
		meta.setNeedAccessLog(DomHelper.readAttr(element, MetaConstants.OPERATION_NEEDACCESSLOG, false));
		meta.setUploadFile(DomHelper.readAttr(element, MetaConstants.OPERATION_UPLOADFILE, false));
		meta.setUploadType(DomHelper.readAttr(element, MetaConstants.OPERATION_UPLOADTYPE, ""));
		meta.setIconCode(DomHelper.readAttr(element, MetaConstants.COMMON_ICON_CODE, ""));
		String displayMode = DomHelper.readAttr(element, MetaConstants.ICON_DISPLAY_MODE, null);
		if (displayMode != null) {
			meta.setDisplayMode(IconDisplayMode.parse(displayMode));
		}
		meta.setTCode(DomHelper.readAttr(element, MetaConstants.OPERATION_TCODE, ""));
		meta.setActivity(DomHelper.readAttr(element, MetaConstants.OPERATION_ACTIVITY, ""));
		meta.setTransfer(DomHelper.readBool(element, MetaConstants.OPERATION_ISTRANSFER, null));
	}

}
