package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TableFilterType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaTableFilter;

public class MetaTableFilterAction extends BaseDomAction<MetaTableFilter> {

	@Override
	public void load(Document document, Element element, MetaTableFilter meta,
			int runType) {
		meta.setFilter(DomHelper.readCDATAContent(element).trim().intern());
		meta.setType(TableFilterType.parse(DomHelper.readAttr(element, MetaConstants.TABLEFILTER_TYPE, "")));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.TABLEFILTER_IMPL, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTableFilter meta,
			int runType) {
		DomHelper.writeCDATAContent(document, element, meta.getFilter());
		DomHelper.writeAttr(element, MetaConstants.TABLEFILTER_TYPE, TableFilterType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.TABLEFILTER_IMPL, meta.getImpl(), "");
	}

}
