package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaCondition;

public class MetaConditionAction extends BaseDomAction<MetaCondition> {

	@Override
	public void load(Document document, Element element, MetaCondition meta, int runType) {
		meta.setTag(DomHelper.readAttr(element, MetaConstants.COMMON_TAG, ""));
		meta.setSign(CondSign.parse(DomHelper.readAttr(element, MetaConstants.CONDITION_SIGN, "")));
		meta.setGroup(DomHelper.readAttr(element, MetaConstants.CONDITION_GROUP, ""));
		meta.setGroupHead(DomHelper.readAttr(element, MetaConstants.CONDITION_GROUP_HEAD, false));
		meta.setGroupTail(DomHelper.readAttr(element, MetaConstants.CONDITION_GROUP_TAIL, false));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.CONDITION_IMPL, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setSubTableKey(DomHelper.readAttr(element, MetaConstants.CONDITION_SUBTABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_COLUMNKEY, ""));
		meta.setTarget(DomHelper.readAttr(element, MetaConstants.CONDITION_TARGET, ""));
		meta.setLimitToSource(DomHelper.readAttr(element, MetaConstants.CONDITION_LIMIT2SOURCE, false));
		meta.setNeedReset(DomHelper.readAttr(element, MetaConstants.CONDITION_NEEDRESET, true));
		meta.setLoadHistoryInput(DomHelper.readAttr(element, MetaConstants.CONDITION_LOADHISTORYINPUT, false));
		meta.setOnlyFilter(DomHelper.readAttr(element, MetaConstants.CONDITION_ONLYFILTER, false));
		meta.setUseAdvancedQuery(DomHelper.readAttr(element, MetaConstants.COMPONENT_USE_ADVANCED_QUERY, false));
	}

	@Override
	public void save(Document document, Element element, MetaCondition meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_TAG, meta.getTag(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_SIGN, CondSign.toString(meta.getSign()), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_GROUP, meta.getGroup(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_GROUP_HEAD, meta.isGroupHead(), false);
		DomHelper.writeAttr(element, MetaConstants.CONDITION_GROUP_TAIL, meta.isGroupTail(), false);
		DomHelper.writeAttr(element, MetaConstants.CONDITION_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_SUBTABLEKEY, meta.getSubTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_TARGET, meta.getTarget(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_LIMIT2SOURCE, meta.isLimitToSource(), false);
		DomHelper.writeAttr(element, MetaConstants.CONDITION_NEEDRESET, meta.needReset(), true);
		DomHelper.writeAttr(element, MetaConstants.CONDITION_LOADHISTORYINPUT, meta.isLoadHistoryInput(), false);
		DomHelper.writeAttr(element, MetaConstants.CONDITION_ONLYFILTER, meta.isOnlyFilter(), false);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_USE_ADVANCED_QUERY, meta.isUseAdvancedQuery(), false);
	}

}
