package com.bokesoft.yes.meta.persist.dom.businessdiagram.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.MetaBusinessDiagramConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramNode;

public class MetaBusinessDiagramNodeAction extends BaseDomAction<MetaBusinessDiagramNode> {

	@Override
	public void load(Document document, Element element,
			MetaBusinessDiagramNode meta, int runType) {
		meta.setID(DomHelper.readAttr(element, MetaBusinessDiagramConstants.ID, -1));
		meta.setKey(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Key, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Caption, ""));
		meta.setX(DomHelper.readAttr(element, MetaBusinessDiagramConstants.X, 0));
		meta.setY(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Y, 0));
		meta.setWidth(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Width, 0));
		meta.setHeight(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Height, 0));
		meta.setType(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Type, ""));
		meta.setStatus(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Status, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaBusinessDiagramNode meta, int runType) {
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.ID, meta.getID(), -1);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Key, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Caption, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.X, meta.getX(), 0);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Y, meta.getY(), 0);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Width, meta.getWidth(), 0);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Height, meta.getHeight(), 0);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Type, meta.getType(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Status, meta.getStatus(), "");
	}
}