package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;

public class MetaStateActionAction extends MetaNodeAction<MetaStateAction> {

	@Override
	public void load(Document doc, Element node, MetaStateAction meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setDenyNodeKey(DomHelper.readAttr(node, BPMConstants.NODE_DENY_NODE_KEY, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaStateAction meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_DENY_NODE_KEY, meta.getDenyNodeKey(), "");
	}

}
