package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.type.ConditionType;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;

public class MetaCountersignAction extends MetaUserTaskAction<MetaCountersign> {

	@Override
	public void load(Document doc, Element node, MetaCountersign meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setPassType(ConditionType.parseString(DomHelper.readAttr(node, BPMConstants.NODE_PASS_TYPE, ConditionType.STR_NONE)));
		meta.setPassCondition(DomHelper.readAttr(node, BPMConstants.NODE_PASS_CONDITION, ""));
		meta.setValidType(ConditionType.parseString(DomHelper.readAttr(node, BPMConstants.NODE_VALID_TYPE, ConditionType.STR_NONE)));
		meta.setValidCondition(DomHelper.readAttr(node, BPMConstants.NODE_VALID_CONDITION, ""));
		meta.setFinishType(ConditionType.parseString(DomHelper.readAttr(node, BPMConstants.NODE_FINISH_TYPE, ConditionType.STR_NONE)));
		meta.setFinishCondition(DomHelper.readAttr(node, BPMConstants.NODE_FINISH_CONDITION, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaCountersign meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_PASS_TYPE, ConditionType.formatString(meta.getPassType()), ConditionType.STR_NONE);
		DomHelper.writeAttr(node, BPMConstants.NODE_PASS_CONDITION, meta.getPassCondition(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_VALID_TYPE, ConditionType.formatString(meta.getValidType()), ConditionType.STR_NONE);
		DomHelper.writeAttr(node, BPMConstants.NODE_VALID_CONDITION, meta.getValidCondition(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_FINISH_TYPE, ConditionType.formatString(meta.getFinishType()), ConditionType.STR_NONE);
		DomHelper.writeAttr(node, BPMConstants.NODE_FINISH_CONDITION, meta.getFinishCondition(), "");
	}
}
