package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;

public class MetaDictionaryAction extends BaseDomAction<MetaDictionary> {

	@Override
	public void load(Document doc, Element node, MetaDictionary meta, int runType) {
		meta.setDictionaryKey(DomHelper.readAttr(node, BPMConstants.PARTICIPATOR_DICTIONARYKEY, ""));
		meta.setItemID(DomHelper.readAttr(node, BPMConstants.PARTICIPATOR_ITEMID, ""));
		meta.setCode(DomHelper.readAttr(node, BPMConstants.PARTICIPATOR_CODE, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaDictionary meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.PARTICIPATOR_DICTIONARYKEY, meta.getDictionaryKey(), "");
		DomHelper.writeAttr(node, BPMConstants.PARTICIPATOR_ITEMID, meta.getItemID(), "");
		DomHelper.writeAttr(node, BPMConstants.PARTICIPATOR_CODE, meta.getCode(), "");
	}

}
