package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;

public class MetaDefaultSequenceFlowAction extends MetaSequenceFlowAction<MetaDefaultSequenceFlow> {

	@Override
	public void load(Document doc, Element node, MetaDefaultSequenceFlow meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setDefaultFlow(DomHelper.readAttr(node, BPMConstants.TRANSITION_DEFAULT_FLOW, true));
	}
	
	@Override
	public void save(Document doc, Element node, MetaDefaultSequenceFlow meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.TRANSITION_DEFAULT_FLOW, meta.isDefaultFlow(), true);
	}
}
