package com.bokesoft.yes.meta.persist.dom.app;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.app.MetaClientAppStatusInfoItem;

public class MetaClientAppStatusInfoItemAction extends BaseDomAction<MetaClientAppStatusInfoItem> {

	@Override
	public void load(Document document, Element element,
			MetaClientAppStatusInfoItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setFormulaCaption(DomHelper.readAttr(element, MetaConstants.COMMON_FORMULA_CAPTION, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaClientAppStatusInfoItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMULA_CAPTION, meta.getFormulaCaption(), "");
	}

}
