package com.bokesoft.yes.meta.persist.dom.app;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yigo.meta.app.MetaClientAppDef;
import com.bokesoft.yigo.meta.app.MetaClientAppStatusInfo;
import com.bokesoft.yigo.meta.app.MetaClientAppStatusInfoItem;

public class MetaClientAppDefActionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaClientAppDef.TAG_NAME, new MetaClientAppDefAction() },
				{ MetaClientAppStatusInfo.TAG_NAME, new MetaClientAppStatusInfoAction() },
				{ MetaClientAppStatusInfoItem.TAG_NAME, new MetaClientAppStatusInfoItemAction() }
		};
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}

	/** 应用定义实例 */
	private static MetaClientAppDefActionMap instance = null;

	/**
	 * 取得应用定义实例
	 * 
	 * @return 应用定义实例
	 */
	public static MetaClientAppDefActionMap getInstance() {
		if (instance == null) {
			instance = new MetaClientAppDefActionMap();
		}
		return instance;
	}
}
