/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.datamigration.calculate;

import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.calculate.MetaColumnM;
import com.bokesoft.yigo.meta.datamigration.calculate.MetaMigrationTableParas;
import com.bokesoft.yigo.meta.datamigration.calculate.MetaPeriodColumn;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationCheckRule;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MetaMigrationTable {
    private String key = null;
    private String dbTableName = "";
    private String tag = null;
    private ArrayList<MetaColumnM> groupColumnList = new ArrayList();
    private ArrayList<MetaColumnM> dataColumnList = new ArrayList();
    private MetaPeriodColumn periodColumn = null;
    private List<MetaMigrationCheckRule> checkRuleList = new ArrayList<MetaMigrationCheckRule>();
    private int migrationUpdateStrategy = 2;
    private HashMap<String, MetaMigrationTableParas> parasMap = new HashMap();

    public void init(MetaDataObject dataObject) {
        MetaTable targetMetaTable = (MetaTable)dataObject.getTableCollection().get(0);
        this.migrationUpdateStrategy = dataObject.getMigrationUpdateStrategy();
        if (dataObject.getMigrationCheckRuleCollection() != null) {
            for (MetaMigrationCheckRule rule : dataObject.getMigrationCheckRuleCollection()) {
                this.checkRuleList.add(rule);
            }
        }
        for (MetaColumn column : targetMetaTable) {
            if (!column.isPersist().booleanValue() || column.isSystemControlField().booleanValue()) continue;
            MetaColumnM mc = null;
            if (column.getGroupType() == 1) {
                this.periodColumn = new MetaPeriodColumn();
                this.periodColumn.setPeriodGranularity(column.getPeriodGranularity());
                this.periodColumn.setPeriodImpl(column.getPeriodImpl());
                this.periodColumn.setSplitType(column.getSplitType());
                mc = this.periodColumn;
            } else {
                mc = new MetaColumnM();
            }
            mc.setDataType(column.getDataType());
            mc.setDbColumnName(column.getDBColumnName());
            mc.setKey(column.getKey());
            if (column.isGroup()) {
                this.groupColumnList.add(mc);
                continue;
            }
            this.dataColumnList.add(mc);
        }
        this.tag = dataObject.getCaption() == null ? "" : dataObject.getCaption() + "(" + dataObject.getKey() + ")";
    }

    public List<MetaMigrationCheckRule> getCheckRuleList() {
        return this.checkRuleList;
    }

    public MetaPeriodColumn getPeriodColumn() {
        return this.periodColumn;
    }

    public ArrayList<MetaColumnM> getGroupColumnList() {
        return this.groupColumnList;
    }

    public ArrayList<MetaColumnM> getDataColumnList() {
        return this.dataColumnList;
    }

    public void put(String key, MetaDataMigration migration, IMetaFactory metaFactory) throws Throwable {
        MetaMigrationTableParas paras = this.parasMap.get(key);
        if (paras == null) {
            paras = new MetaMigrationTableParas(this);
            this.parasMap.put(key, paras);
        }
        paras.init(migration, metaFactory);
    }

    public MetaMigrationTableParas getMetaMigrationTableParas(String srcKey) {
        return this.parasMap.get(srcKey);
    }

    public String getTag() {
        return this.tag;
    }

    public int getMigrationUpdateStrategy() {
        return this.migrationUpdateStrategy;
    }

    public String getKey() {
        return this.key;
    }

    public String getBindingDBTableName() {
        return this.dbTableName != null && !this.dbTableName.isEmpty() ? this.dbTableName : this.key;
    }
}

