/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.checker;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.checker.IMetaSolutionChecker;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class MetaDataElementKeyChecker
implements IMetaSolutionChecker {
    @Override
    public void doCheck(IMetaFactory factory, String solutionKey) throws Throwable {
        if (solutionKey == null || solutionKey.isEmpty()) {
            return;
        }
        MetaDataElementDef primaryDataElementDef = factory.getDataElementDef("");
        if (primaryDataElementDef == null || primaryDataElementDef.getDataElementCollection() == null) {
            return;
        }
        MetaDataElementDef dataElementDef = factory.getDataElementDef(solutionKey);
        if (dataElementDef == null || dataElementDef.getDataElementCollection() == null) {
            return;
        }
        Set<String> set1 = primaryDataElementDef.getDataElementCollection().keySet();
        Set<String> set2 = dataElementDef.getDataElementCollection().keySet();
        HashSet<String> lowerCaseSet1 = new HashSet<String>();
        HashSet<String> lowerCaseSet2 = new HashSet<String>();
        for (String s : set1) {
            lowerCaseSet1.add(s.toLowerCase());
        }
        for (String s : set2) {
            lowerCaseSet2.add(s.toLowerCase());
        }
        TreeSet<String> intersection = new TreeSet<String>();
        intersection.addAll(lowerCaseSet1);
        intersection.retainAll(lowerCaseSet2);
        if (!intersection.isEmpty()) {
            String s;
            s = intersection.stream().collect(Collectors.joining(","));
            throw new MetaException(113, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatKeyDefined"), (Object[])new Object[]{s}));
        }
    }
}

