/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.bpm.total;

import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfoCollection;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMapCollection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MetaBPM
extends AbstractMetaObject
implements IElementMerge<MetaBPM> {
    public static final String TAG_NAME = "BPM";
    public static final String DATA_MIGRATION_KEY = "BPM_Migration";
    private String initDate = DateUtil.getDateFormatText(null, (String)"yyyy.MM.dd HH:mm:ss z");
    private MetaProcessDeployInfoCollection deployInfoCollection = new MetaProcessDeployInfoCollection();
    private MetaProcessMapCollection mapCollection = new MetaProcessMapCollection();
    private HashMap<String, ProcessDefinitionProfile> profileMap = new HashMap();

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        list.add(this.deployInfoCollection);
        list.add(this.mapCollection);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject amo = null;
        if (tagName.equalsIgnoreCase("DeployInfoCollection")) {
            this.deployInfoCollection = new MetaProcessDeployInfoCollection();
            amo = this.deployInfoCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("ProcessMapCollection")) {
            this.mapCollection = new MetaProcessMapCollection();
            amo = this.mapCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        }
        return amo;
    }

    @Override
    public AbstractMetaObject clone() {
        return null;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaBPM();
    }

    public String getInitDate() {
        return this.initDate;
    }

    public void setInitDate(String initDate) {
        this.initDate = initDate;
    }

    public HashMap<String, ProcessDefinitionProfile> getProfileMap() {
        return this.profileMap;
    }

    public void setProfileMap(HashMap<String, ProcessDefinitionProfile> profileMap) {
        this.profileMap = profileMap;
    }

    public MetaProcessDeployInfoCollection getMetaBPMDeployInfoCollection() {
        return this.deployInfoCollection;
    }

    public void setMetaBPMDeployInfoCollection(MetaProcessDeployInfoCollection deployInfoCollection) {
        this.deployInfoCollection = deployInfoCollection;
    }

    public MetaProcessMapCollection getMetaProcessMapCollection() {
        return this.mapCollection;
    }

    public void setMetaMapCollection(MetaProcessMapCollection mapCollection) {
        this.mapCollection = mapCollection;
    }

    @Override
    public MetaBPM toMerge(MetaBPM obj) {
        if (obj != null) {
            for (MetaProcessDeployInfo metaProcessDeployInfo : obj.getMetaBPMDeployInfoCollection()) {
                if (this.deployInfoCollection.containsKey(metaProcessDeployInfo.getKey())) {
                    throw new MetaException(99, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatProcessDeploy"), (Object[])new Object[]{metaProcessDeployInfo.getKey()}));
                }
                this.deployInfoCollection.add(metaProcessDeployInfo);
            }
            for (MetaProcessMap metaProcessMap : obj.getMetaProcessMapCollection()) {
                this.mapCollection.add(metaProcessMap);
            }
            Set<Map.Entry<String, ProcessDefinitionProfile>> entrySet = obj.getProfileMap().entrySet();
            for (Map.Entry<String, ProcessDefinitionProfile> entry : entrySet) {
                if (this.profileMap.containsKey(entry.getKey())) {
                    String key = entry.getKey();
                    ProcessDefinitionProfile value = entry.getValue();
                    throw new MetaException(100, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatProcessDefined"), (Object[])new Object[]{key}));
                }
                this.profileMap.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }
}

