/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.process;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.process.MetaDataObjectTemplateUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaFrame;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class MetaFormFrameProcess {
    private IMetaFactory metaFactory = null;
    private MetaForm metaForm = null;
    private MetaForm metaTemp = null;
    private boolean tmpHasToolbar = false;
    private String toolbarKey = null;

    public MetaFormFrameProcess(IMetaFactory metaFactory, MetaForm metaForm, MetaForm metaTemp) {
        this.metaFactory = metaFactory;
        this.metaForm = (MetaForm)metaForm.clone();
        this.metaTemp = (MetaForm)metaTemp.clone();
    }

    public MetaForm process() throws Throwable {
        if (this.metaTemp.getFormType() == 7 || this.metaTemp.getFormType() == 8) {
            return this.metaForm;
        }
        this.processBody();
        this.processOpt();
        this.processDataSource();
        this.processMacroCollection();
        this.processQueryCollection();
        this.processParaCollection();
        this.metaForm.doPostProcess(0, new Callback<AbstractMetaObject, Boolean>(){

            public Boolean call(AbstractMetaObject param) throws Throwable {
                if (param instanceof MetaDictProperties) {
                    ((MetaDictProperties)param).calItemKey(MetaFormFrameProcess.this.metaForm.getProject().getKey());
                }
                return true;
            }
        });
        if (this.tmpHasToolbar) {
            for (MetaComponent com : this.metaForm.getAllComponents()) {
                if (com.getControlType() != 223 || com.getKey().equals(this.toolbarKey)) continue;
                ((MetaToolBar)com).setIsDefault(false);
                break;
            }
        }
        this.metaForm.setTemplateKey(this.metaTemp.getKey());
        return this.metaForm;
    }

    private void processParaCollection() throws Throwable {
        MetaFormParaCollection para1 = this.metaForm.getFormParaCollection();
        MetaFormParaCollection para2 = this.metaTemp.getFormParaCollection();
        MetaFormParaCollection para3 = null;
        if (para2 != null) {
            if (para1 != null) {
                Iterator it = para2.iterator();
                MetaFormPara p = null;
                String key = null;
                while (it.hasNext()) {
                    p = (MetaFormPara)it.next();
                    key = p.getKey();
                    if (para1.get(key) != null) continue;
                    para1.add(p);
                }
                para3 = para1;
            } else {
                para3 = para2;
            }
            this.metaForm.setFormParaCollection(para3);
        }
    }

    private void processQueryCollection() throws Throwable {
        MetaQueryCollection query1 = this.metaForm.getQueryCollection();
        MetaQueryCollection query2 = this.metaTemp.getQueryCollection();
        MetaQueryCollection query3 = null;
        if (query2 != null) {
            if (query1 != null) {
                Iterator it = query2.iterator();
                MetaQuery q = null;
                String key = null;
                while (it.hasNext()) {
                    q = (MetaQuery)it.next();
                    key = q.getKey();
                    if (query1.get(key) != null) continue;
                    query1.add(q);
                }
                query3 = query1;
            } else {
                query3 = query2;
            }
            this.metaForm.setQueryCollection(query3);
        }
    }

    private void processMacroCollection() throws Throwable {
        MetaMacroCollection mac1 = this.metaForm.getMacroCollection();
        MetaMacroCollection mac2 = this.metaTemp.getMacroCollection();
        MetaMacroCollection mac3 = null;
        if (mac2 != null) {
            if (mac1 != null) {
                Iterator it = mac2.iterator();
                MetaMacro macro = null;
                String key = null;
                while (it.hasNext()) {
                    macro = (MetaMacro)it.next();
                    key = macro.getKey();
                    if (mac1.get(key) != null) continue;
                    mac1.add(macro);
                }
                mac3 = mac1;
            } else {
                mac3 = mac2;
            }
            this.metaForm.setMacroCollection(mac3);
        }
    }

    private void processDataSource() throws Throwable {
        MetaDataSource ds1 = this.metaForm.getDataSource();
        MetaDataSource ds2 = this.metaTemp.getDataSource();
        if (ds2 != null) {
            MetaDataSource newDs = null;
            if (ds1 != null) {
                MetaDataObjectTemplateUtil util = new MetaDataObjectTemplateUtil(ds2.getDataObject(), ds1.getDataObject(), null, null);
                util.replace();
                newDs = ds1;
            } else {
                newDs = ds2;
            }
            this.metaForm.setDataSource(newDs);
        }
    }

    private void processBody() throws Throwable {
        MetaBody metaBody = this.metaTemp.getMetaBody();
        if (metaBody != null) {
            Iterator it = metaBody.iterator();
            MetaComponent metaComponent = null;
            while (it.hasNext()) {
                MetaBlock metaBlock;
                MetaComponent metaRoot;
                metaComponent = (MetaComponent)it.next();
                if (metaComponent.isPanel()) {
                    this.processPanel((MetaPanel)metaComponent);
                    continue;
                }
                if (metaComponent.getControlType() != 20000 || !(metaRoot = (metaBlock = (MetaBlock)metaComponent).getRoot()).isPanel()) continue;
                this.processPanel((MetaPanel)metaRoot);
            }
        }
        this.metaForm.setMetaBody((MetaBody)metaBody.clone());
    }

    private void processOpt() throws Throwable {
        MetaOperationCollection newOC = null;
        MetaOperationCollection oc = this.metaForm.getOperationCollection();
        MetaOperationCollection oc2 = this.metaTemp.getOperationCollection();
        if (oc2 != null) {
            if (oc != null) {
                Iterator<KeyPairCompositeObject> it = oc2.iterator();
                KeyPairCompositeObject metaItem = null;
                String key = null;
                while (it.hasNext()) {
                    metaItem = it.next();
                    key = metaItem.getKey();
                    if (oc.get(key) != null) continue;
                    oc.add(metaItem);
                }
                newOC = oc;
            } else {
                newOC = oc2;
            }
            this.metaForm.setOperationCollection(newOC);
        }
    }

    private void processPanel(MetaPanel metaPanel) throws Throwable {
        Iterator<MetaComponent> it = metaPanel.iteratorComponent();
        MetaComponent metaComponent2 = null;
        ArrayList<MetaComponent> newTemplateComponentArray = null;
        while (it.hasNext()) {
            MetaSubDetail metaSubDetail;
            MetaComponent root;
            metaComponent2 = it.next();
            if (metaComponent2.getControlType() == 273) {
                MetaFrame metaFrame = (MetaFrame)metaComponent2;
                if (newTemplateComponentArray == null) {
                    newTemplateComponentArray = new ArrayList<MetaComponent>();
                }
                MetaComponent tmpMetaComponent = null;
                tmpMetaComponent = this.findRoot(metaFrame);
                newTemplateComponentArray.add(tmpMetaComponent);
                continue;
            }
            if (metaComponent2.getControlType() == 223) {
                this.tmpHasToolbar = true;
                this.toolbarKey = metaComponent2.getKey();
                continue;
            }
            if (metaComponent2.isPanel()) {
                this.processPanel((MetaPanel)metaComponent2);
                continue;
            }
            if (metaComponent2.getControlType() != 247 || (root = (metaSubDetail = (MetaSubDetail)metaComponent2).getRoot()) == null || !root.isPanel()) continue;
            this.processPanel((MetaPanel)root);
        }
        if (newTemplateComponentArray != null && !newTemplateComponentArray.isEmpty()) {
            LinkedList newComponentArray = new LinkedList();
            it = metaPanel.iteratorComponent();
            int index = 0;
            while (it.hasNext()) {
                metaComponent2 = it.next();
                if (metaComponent2.getControlType() == 273) {
                    newComponentArray.add(newTemplateComponentArray.get(index));
                    ++index;
                    continue;
                }
                newComponentArray.add(metaComponent2);
            }
            metaPanel.clear();
            for (MetaComponent metaComponent2 : newComponentArray) {
                metaPanel.addComponent(metaComponent2);
            }
        }
    }

    private MetaBlock getPrimaryBlock(MetaBody metaBody) throws Throwable {
        Object metaFirstElement;
        MetaBlock metaBlock = null;
        if (metaBody.size() == 1 && (metaFirstElement = metaBody.get(0)) instanceof MetaBlock) {
            metaBlock = (MetaBlock)metaFirstElement;
        }
        return metaBlock;
    }

    private MetaComponent findRoot(MetaFrame metaFrame) throws Throwable {
        MetaComponent metaRoot = null;
        MetaBody metaBody = this.metaForm.getMetaBody();
        MetaBlock metaBlock = this.getPrimaryBlock(metaBody);
        if (metaBlock != null) {
            metaRoot = metaBlock.getRoot();
        }
        if (metaRoot != null) {
            metaRoot.setX(metaFrame.getX());
            metaRoot.setXSpan(metaFrame.getXSpan());
            metaRoot.setY(metaFrame.getY());
            metaRoot.setYSpan(metaFrame.getYSpan());
            if (metaRoot instanceof MetaPanel) {
                ((MetaPanel)metaRoot).setOverflowX(3);
                ((MetaPanel)metaRoot).setOverflowY(3);
            }
        }
        return metaRoot;
    }
}

