/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import java.util.HashMap;

public abstract class MetaActionMap
implements IMetaActionMap {
    private HashMap<String, IMetaAction<AbstractMetaObject>> actionMap = new HashMap();
    private HashMap<String, HashMap<String, IMetaAction<AbstractMetaObject>>> hostActionMap = null;

    public MetaActionMap() {
        Object[][] hostActionLookupTable;
        Object[][] actionLookupTable = this.getActionLookupTable();
        if (actionLookupTable != null) {
            MetaActionMap.createMap(this.actionMap, actionLookupTable);
        }
        if ((hostActionLookupTable = this.getHostActionLookupTable()) != null) {
            this.hostActionMap = new HashMap();
            int length = hostActionLookupTable.length;
            for (int i = 0; i < length; ++i) {
                String tagName = (String)hostActionLookupTable[i][0];
                Object[][] table = (Object[][])hostActionLookupTable[i][1];
                HashMap<String, IMetaAction<AbstractMetaObject>> map = new HashMap<String, IMetaAction<AbstractMetaObject>>();
                MetaActionMap.createMap(map, table);
                this.hostActionMap.put(tagName, map);
            }
        }
    }

    private static void createMap(HashMap<String, IMetaAction<AbstractMetaObject>> map, Object[][] table) {
        int length = table.length;
        Object[] line = null;
        for (int i = 0; i < length; ++i) {
            line = table[i];
            String tagName = (String)line[0];
            IMetaAction action = (IMetaAction)line[1];
            map.put(tagName, action);
        }
    }

    @Override
    public IMetaAction<AbstractMetaObject> getAction(String tag) {
        return this.actionMap.get(tag);
    }

    @Override
    public IMetaAction<AbstractMetaObject> getAction(String parentTag, String tag) {
        if (this.hostActionMap == null) {
            return null;
        }
        IMetaAction<AbstractMetaObject> action = null;
        HashMap<String, IMetaAction<AbstractMetaObject>> map = this.hostActionMap.get(parentTag);
        action = map != null ? map.get(tag) : null;
        return action;
    }

    protected abstract Object[][] getActionLookupTable();

    protected abstract Object[][] getHostActionLookupTable();
}

