package com.bokesoft.yigo.meta.taskflow.node;

import com.bokesoft.yes.meta.persist.dom.taskflow.NodeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 分支节点
 */
public class MetaFork extends MetaNode {

	public final static String TAG_NAME = "Fork";
	
	private String condition = null;
	
	private MetaCondition conditionNode = null;
	
	/**
	 * 获取条件
	 * @return 条件
	 */
	public String getCondition() {
		return this.condition;
	}
	
	/**
	 * 设置条件
	 * @param condition 条件
	 */
	public void setCondition(String condition) {
		this.condition = condition;
		if ( condition != null && !condition.isEmpty() ) {
			if ( this.conditionNode == null ) {
				this.conditionNode = new MetaCondition();
			}
			this.conditionNode.setContent(condition);
		} else {
			this.conditionNode = null;
		}
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.FORK;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if(resultMetaObject == null) {
			if(MetaCondition.TAG_NAME.equals(tagName)) {
				this.conditionNode = new MetaCondition();
				resultMetaObject = this.conditionNode;
			}
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaFork clone = (MetaFork) super.clone();
		clone.setCondition(condition);
		return clone;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFork();
	}
}