package com.bokesoft.yigo.meta.task.node;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.task.TaskNodeType;

public class MetaTaskDecision extends MetaTaskNode {
	public static final String TAG_NAME = "Decision";
	
	private MetaBaseScript script = null;
	
	public MetaBaseScript getScript() {
		return script;
	}

	public void setScript(MetaBaseScript script) {
		this.script = script;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (child == null) {
			if (MetaConstants.COMMON_CONDITION.equals(tagName)) {
				script = new MetaBaseScript(tagName);
				child = script;
			}
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTaskDecision obj = (MetaTaskDecision) super.clone();
		obj.script = script == null ? null : (MetaBaseScript)script.clone();
		return obj;
	}
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTaskDecision();
	}

	@Override
	public int getNodeType() {
		return TaskNodeType.DECISION;
	}

}
