package com.bokesoft.yigo.meta.task;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yes.meta.persist.dom.task.MetaTaskLoad;
import com.bokesoft.yes.meta.persist.dom.task.MetaTaskProcessLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.task.deploy.MetaTask;
import com.bokesoft.yigo.meta.task.deploy.MetaTaskProcessDeployInfo;

public class MetaTaskScanLoad extends BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private MetaTask metaTask = null;

	public MetaTaskScanLoad(MetaTask metaTask, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.TASK_FOLD, context);
		this.runType = runType;
		this.metaTask = metaTask;
	}
	
	@Override
	public void load() throws Throwable {
		MetaTaskLoad taskLoad = new MetaTaskLoad(runType);
		String resource = resourcePath + ".xml";
		taskLoad.load(resolver, resource);
		MetaTask mt = (MetaTask) taskLoad.getRootMetaObject();
		if (mt != null) {
			for (MetaTaskProcessDeployInfo info : mt.getDeployInfoCollection()) {
				metaTask.getDeployInfoCollection().add(info);
			}
		}
		super.load();
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		MetaTaskProcessLoad taskProcessLoad = new MetaTaskProcessLoad(runType);
		taskProcessLoad.load(resolver, filePath);
		MetaTaskProcess metaTaskProcess = (MetaTaskProcess) taskProcessLoad.getRootMetaObject();
		if (metaTaskProcess != null) {
			MetaTaskProcessProfile metaTaskProcessProfile = new MetaTaskProcessProfile();
			String key = metaTaskProcess.getKey();
			int version = metaTaskProcess.getVersion();
			metaTaskProcessProfile.setKey(key);		
			metaTaskProcessProfile.setCaption(metaTaskProcess.getCaption());
			metaTaskProcessProfile.setVersion(version);
			metaTaskProcessProfile.setResource(filePath);
			metaTaskProcessProfile.setDefination(metaTaskProcess);
			metaTaskProcessProfile.setProject(metaProject);
			metaTask.getProfileMap().put(key + "_V" + version , metaTaskProcessProfile);
		}

	}

}
