package com.bokesoft.yigo.meta.report;

/**
 * 报表中的列的类型
 * @author 王元和
 * @since YES 1.0
 *
 */
public class ReportColumnType {
	/** 固定列 */
	public static final int Fix = 0;
	public static final String STR_Fix = "Fix";
	
	/** 扩展列 */
	public static final int Expand = 1;
	public static final String STR_Expand = "Expand";
	
	/** 分组列 */
	public static final int Group = 2;
	public static final String STR_Group = "Group";
	
	/** 汇总列 */
	public static final int Total = 3;
	public static final String STR_Total = "Total";
	
	public static int parse(String s) {
		int type = -1;
		if ( STR_Fix.equalsIgnoreCase(s) ) {
			type = Fix;
		} else if ( STR_Expand.equalsIgnoreCase(s) ) {
			type = Expand;
		} else if ( STR_Group.equalsIgnoreCase(s) ) {
			type = Group;
		} else if ( STR_Total.equalsIgnoreCase(s) ) {
			type = Total;
		}
		return type;
	}
	
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = null;
		switch ( type ) {
		case Fix:
			s = STR_Fix;
			break;
		case Expand:
			s = STR_Expand;
			break;
		case Group:
			s = STR_Group;
			break;
		case Total:
			s = STR_Total;
			break;
		}
		return s;
	}
}
