package com.bokesoft.yigo.meta.permission.filter;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.MappingDataType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;

public class MetaSourceData extends AbstractMetaObject {
	public static final String TAG_NAME = "SourceData";
	/** 来源类型*/
	private Integer type = MappingDataType.FORMULA;
	
	/** 当来源于Formula时，定义的表达式*/
	private String formula="";
	
	/** 当来源于Field时，定义的表名与列名*/
	private String tableKey = "";
	private String columnKey="";
	private Boolean detail = false;
	
	/** 当来源于Para时，定义的参数下标*/
	private Integer paraIndex=-1;
	/** 当来源于Para时，定义的参数的键*/
	private String paraKey ="";
	
	/** 当来源于Query*/
	private MetaQueryDef queryDef = null;
	
	/** 当来源于自定义*/
	private MetaItemList items = new MetaItemList();
	/** 数据类型*/
	private Integer dataType = DataType.INT;
	
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getFormula() {
		return formula;
	}

	public void setFormula(String formula) {
		this.formula = formula;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getColumnKey() {
		return columnKey;
	}

	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	public Boolean isDetail() {
		return detail;
	}

	public void setDetail(Boolean detail) {
		this.detail = detail;
	}

	public Integer getParaIndex() {
		return paraIndex;
	}

	public void setParaIndex(Integer paraIndex) {
		this.paraIndex = paraIndex;
	}

	public MetaQueryDef getQueryDef() {
		return queryDef;
	}

	public String getParaKey() {
		return paraKey;
	}

	public void setParaKey(String paraKey) {
		this.paraKey = paraKey;
	}

	public void setQueryDef(MetaQueryDef queryDef) {
		this.queryDef = queryDef;
	}

	public MetaItemList getItems() {
		return items;
	}

	public void setItems(MetaItemList items) {
		this.items = items;
	}

	public Integer getDataType() {
		return dataType;
	}

	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll2(list, queryDef,items);
	}

	@Override
	public String getTagName() {
		return MetaSourceData.TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (child == null) {
			if (MetaQueryDef.TAG_NAME.equals(tagName)) {
				queryDef = new MetaQueryDef();
				child = queryDef;
			} else if (MetaItemList.TAG_NAME.equals(tagName)){
				items = new MetaItemList();
				child = items;
			}
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSourceData newObj = new MetaSourceData();
		newObj.type = type;
		newObj.formula = formula;
		newObj.tableKey = tableKey;
		newObj.columnKey = columnKey;
		newObj.detail = detail;
		newObj.paraIndex = paraIndex;
		newObj.paraKey = paraKey;
		newObj.dataType = dataType;
		newObj.queryDef = queryDef == null ? null : (MetaQueryDef)queryDef.clone();
		newObj.items = items;
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSourceData();
	}
	
	/**
	 * 用于判断当前对象是否为默认值
	 * **/
	public boolean isDefalut(){
		return type == MappingDataType.FORMULA && 
				formula.isEmpty() && tableKey.isEmpty() && 
				columnKey.isEmpty() && paraIndex == -1 &&
				paraKey.isEmpty() && queryDef == null &&
				dataType == DataType.INT && items.size() == 0;
	}

}
