package com.bokesoft.yigo.meta.path;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.relation.path.check.MetaRelationCheckload;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.PathTargetType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.path.check.MetaCheckTarget;
import com.bokesoft.yigo.meta.path.check.MetaRelationCheck;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaRelationScanLoad extends BaseMetaScanLoad {

	private MetaRelationCheck relationCheck = null;

	private MetaRelationList relationList = null;

	private int runType = AppRunType.App;
	
	public MetaRelationScanLoad(MetaRelationCheck relationCheck, MetaRelationList relationList, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject,  DomMetaConstants.RELATIONCHECK_FOLD, context);
		this.relationCheck = relationCheck;
		this.relationList = relationList;
		this.runType = runType;
	}

	public void load() throws Throwable {
		MetaRelationCheckload load = new MetaRelationCheckload(runType);
		load.load(resolver, resourcePath + ".xml");
		MetaRelationCheck rc = (MetaRelationCheck) load.getRootMetaObject();
		if (rc != null) {
			for (MetaCheckTarget a : rc) {
				// TODO 重复性判断，不过当前的机制是碰不到，以后添加
				relationCheck.add(a);
			}
		}
		scan(getRoot(), resourcePath);
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaRelationPath.TAG_NAME.equals(tagName)) {
				MetaRelationProfile metaRelationProfile = new MetaRelationProfile();
				metaRelationProfile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				metaRelationProfile.setType(PathTargetType.parse(profileInfo.optString(MetaConstants.COMMON_TYPE)));
				metaRelationProfile.setFormkey(profileInfo.optString(MetaRelationConstants.RELATION_FORMKEY));
				metaRelationProfile.setTargetkey(profileInfo.optString(MetaRelationConstants.RELATION_TARGETKEY));
				metaRelationProfile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				metaRelationProfile.setProject(metaProject);
				metaRelationProfile.setResource(filePath);
				
				if (relationList.containsKey(metaRelationProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_DATAOBJECT_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatDataObjectDefined), metaProject.getKey(), "", metaRelationProfile.getKey()));
				}
				doFind(parent, parentPath, filePath, fileName, metaRelationProfile);
				relationList.add(metaRelationProfile);
			}
		}
	}

	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaRelationProfile profile) {

	}
}
