package com.bokesoft.yigo.meta.mobiledef.encrypt;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MobileDef中数据加密设置中的相关参数对象，目前只有秘钥参数
 * @author chenzs
 *
 */
public class MetaEncryptPara extends KeyPairMetaObject {

	/** 参数标识*/
	private String key = null;
	/** 参数内容*/
	private String content = null;
	
	@Override
	public String getKey() {
		return key;
	}
	
	/**
	 * 设置对象标识
	 * @param key 对象标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置参数对象内容
	 * @param content 参数对象内容
	 */
	public void setContent(String content) {
		this.content = content;
	}
	
	
	/**
	 * 获取参数对象内容
	 * @return 参数对象内容
	 */
	public String getContent() {
		return content;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaEncryptPara newObj = new MetaEncryptPara();
		newObj.setKey(key);
		newObj.setContent(content);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEncryptPara();
	}

	@Override
	public boolean needPreLoad() {
		return false;
	}
}
