package com.bokesoft.yigo.meta.form.component.view.layout;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaTabLayout extends MetaComponentLayout<MetaLayoutTabItem> {

	/** Tab页的相对分页栏的位置（上、下、左、右） */
	private Integer tabPosition = DirectionType.TOP;

	/** 模式，默认为Fixed-固定，可选值还有Scrollable-可滚动 */
	private Integer tabMode = TabMode.Fixed;

	/** 指示器高度 */
	private DefSize indicatorHeight = null;

	/** 指示器颜色 */
	private String indicatorColor = "";

	/** 是否显示选项卡 */
	private Boolean showHead = true;

	/** Tab页切换触发事件 */
	private MetaBaseScript itemChanged = null;
	
	/** 是否Tab页头悬停 */
	private Boolean hoverHead = false;
	
	/***
	 * 设置是否Tab页头悬停
	 * @param hoverHead 是否Tab页头悬停
	 */
	public void setHoverHead(Boolean hoverHead) {
		this.hoverHead = hoverHead;
	}
	
	/**
	 * 获取是否Tab页头悬停
	 * @return 是否Tab页头悬停
	 */
	public Boolean isHoverHead() {
		return hoverHead;
	}

	/**
	 * 设置Tab页的相对分页栏的位置（上、下、左、右）
	 * 
	 * @param position
	 *            Tab页的相对分页栏的位置（上、下、左、右）
	 */
	public void setTabPosition(Integer position) {
		this.tabPosition = position;
	}

	/**
	 * 获取tab页的相对分页栏的位置（上、下、左、右）
	 * 
	 * @return Tab页的相对分页栏的位置（上、下、左、右）
	 */
	public Integer getTabPosition() {
		return this.tabPosition;
	}

	/**
	 * 设置选项卡显示模式
	 * 
	 * @param tabMode
	 *            显示模式，参考{@link TabMode}
	 */
	public void setTabMode(Integer tabMode) {
		this.tabMode = tabMode;
	}

	/**
	 * 获取选项卡显示模式
	 * 
	 * @return 显示模式，参考{@link TabMode}
	 */
	public Integer getTabMode() {
		return tabMode;
	}

	/**
	 * 设置指示器高度
	 * 
	 * @param indicatorHeight
	 *            指示器高度
	 */
	public void setIndicatorHeight(DefSize indicatorHeight) {
		this.indicatorHeight = indicatorHeight;
	}

	/**
	 * 获取指示器高度
	 * 
	 * @return 指示器高度
	 */
	public DefSize getIndicatorHeight() {
		return indicatorHeight;
	}

	/**
	 * 设置指示器颜色
	 * 
	 * @param indicatorColor
	 *            指示器颜色
	 */
	public void setIndicatorColor(String indicatorColor) {
		this.indicatorColor = indicatorColor;
	}

	/**
	 * 获取指示器颜色
	 * 
	 * @return 指示器颜色
	 */
	public String getIndicatorColor() {
		return indicatorColor;
	}

	/**
	 * 设置是否显示选项卡
	 * 
	 * @param showHead
	 *            是否显示选项卡
	 */
	public void setShowHead(Boolean showHead) {
		this.showHead = showHead;
	}

	/**
	 * 是否显示选项卡
	 * 
	 * @return 是否显示选项卡
	 */
	public Boolean isShowHead() {
		return showHead;
	}

	/**
	 * 获取Tab页切换触发事件
	 * 
	 * @return 事件
	 */
	public MetaBaseScript getItemChanged() {
		return itemChanged;
	}

	/**
	 * 设置Tab页切换触发事件
	 * 
	 * @param itemChanged
	 *            事件
	 */
	public void setItemChanged(MetaBaseScript itemChanged) {
		this.itemChanged = itemChanged;
	}

	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_TAB;
	}

	public static final String TAG_NAME = "TabLayout";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if(itemChanged != null){
			list.add(itemChanged);
		}
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTabLayout newObj = (MetaTabLayout)super.clone();
		newObj.setTabPosition(tabPosition);
		newObj.setTabMode(tabMode);
		newObj.setIndicatorHeight(indicatorHeight);
		newObj.setIndicatorColor(indicatorColor);
		newObj.setShowHead(showHead);
		newObj.setItemChanged(itemChanged == null ? null : (MetaBaseScript)itemChanged.clone());
		newObj.setHoverHead(hoverHead);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTabLayout();
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(tagName.equalsIgnoreCase(MetaConstants.TABPANEL_ITEMCHANGED)){
			itemChanged = new MetaBaseScript(MetaConstants.TABPANEL_ITEMCHANGED);
			resultMetaObject = itemChanged;
		} else if (MetaLayoutTabItem.TAG_NAME.equals(tagName)) {
			MetaLayoutTabItem item = new MetaLayoutTabItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

}
