package com.bokesoft.yigo.meta.form.component.view.layout;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;

public class MetaGridLayout extends MetaComponentLayout<MetaLayoutSpan> {
	private MetaRowDefCollection rowDefCollection = null;
	private MetaColumnDefCollection columnDefCollection = null;
	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_GRID;
	}

	public static final String TAG_NAME = "GridLayout";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {
				rowDefCollection, columnDefCollection
		});
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaGridLayout newObject = (MetaGridLayout)super.clone();
		newObject.setRowDefCollection(rowDefCollection == null ? null : (MetaRowDefCollection)rowDefCollection.clone());
		newObject.setColumnDefCollection(columnDefCollection == null ? null : (MetaColumnDefCollection)columnDefCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridLayout();
	}
	
	public void setRowDefCollection(MetaRowDefCollection rowDefCollection) {
		this.rowDefCollection = rowDefCollection;
	}
	
	public MetaRowDefCollection getRowDefCollection() {
		return this.rowDefCollection;
	}
	
	public void setColumnDefCollection(MetaColumnDefCollection columnDefCollection) {
		this.columnDefCollection = columnDefCollection;
	}
	
	public MetaColumnDefCollection getColumnDefCollection() {
		return this.columnDefCollection;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaLayoutSpan.TAG_NAME.equals(tagName) ) {
			MetaLayoutSpan item = new MetaLayoutSpan();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		} else if ( MetaRowDefCollection.TAG_NAME.equals(tagName) ) {
			rowDefCollection = new MetaRowDefCollection();
			resultMetaObject = rowDefCollection;
		} else if ( MetaColumnDefCollection.TAG_NAME.equals(tagName) ) {
			columnDefCollection = new MetaColumnDefCollection();
			resultMetaObject = columnDefCollection;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}

		return resultMetaObject;
	}
	
	// 根据位置排序,用于处理焦点
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for (MetaLayoutSpan span : this) {
			if (span.getY() + span.getYSpan() > rowDefCollection.size()) {
				throw new MetaException(MetaException.ROW_DEFINITION_OUT_RANGE, 
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RowDefinitionOutRange), getKey(),span.getKey()));
			}
			if (span.getX() + span.getXSpan() > columnDefCollection.size()) {
				throw new MetaException(MetaException.COLUMN_DEFINITION_OUT_RANGE, 
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ColumnDefinitionOutRange), getKey(),span.getKey()));
			}
		} 
	}
}
