package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaFlexGridLayout  extends MetaComponentLayout<MetaLayoutRowIndex> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/** 列数 */
	private Integer columnCount = 1;
	/** 列间距 */
	private Integer columnGap = 0;
	/** 行间距 */
	private Integer rowGap = 0;
	/** 行高 */
	private Integer rowHeight = 30;
	
	public static final String TAG_NAME = "FlexGridLayout";
	
	
	public Integer getColumnCount() {
		return columnCount;
	}

	public void setColumnCount(Integer columnCount) {
		this.columnCount = columnCount;
	}

	public Integer getColumnGap() {
		return columnGap;
	}

	public void setColumnGap(Integer columnGap) {
		this.columnGap = columnGap;
	}

	public Integer getRowGap() {
		return rowGap;
	}

	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}

	public Integer getRowHeight() {
		return rowHeight;
	}

	public void setRowHeight(Integer rowHeight) {
		this.rowHeight = rowHeight;
	}

	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_FLEXGRID;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFlexGridLayout();
	}
	
	
	@Override
	public AbstractMetaObject clone() {
		MetaFlexGridLayout newObject = (MetaFlexGridLayout) super.clone();
		newObject.setColumnCount(columnCount);
		newObject.setColumnGap(columnGap);
		newObject.setRowGap(rowGap);
		newObject.setRowHeight(rowHeight);
		return newObject;
	}

}
