package com.bokesoft.yigo.meta.form.component.view;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaBorderLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaColumnLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableViewLayout;
import com.bokesoft.yigo.meta.form.component.view.overrides.MetaBaseComponentOverrides;
import com.bokesoft.yigo.meta.form.component.view.overrides.MetaComponentOverrides;

/**
 * MetaComponentView定义组件的视图，包括布局和属性覆盖
 * @author wangyh
 *
 */
public class MetaComponentView extends GenericKeyCollectionWithKey<MetaComponentLayout<?>> {
	/** 标识 */
	private String key = "";
	/** 属性覆盖 */
	private MetaBaseComponentOverrides overrides = null;
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] { overrides });
	}

	public static final String TAG_NAME = "ComponentView";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaColumnLayout.TAG_NAME.equals(tagName) ) {
			MetaColumnLayout layout = new MetaColumnLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			this.add(layout);
		} else if ( MetaBorderLayout.TAG_NAME.equals(tagName) ) {
			MetaBorderLayout layout = new MetaBorderLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaFlowLayout.TAG_NAME.equals(tagName) ) {
			MetaFlowLayout layout = new MetaFlowLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaFlexFlowLayout.TAG_NAME.equals(tagName) ) {
			MetaFlexFlowLayout layout = new MetaFlexFlowLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaTabLayout.TAG_NAME.equals(tagName) ) {
			MetaTabLayout layout = new MetaTabLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaSplitLayout.TAG_NAME.equals(tagName) ) {
			MetaSplitLayout layout = new MetaSplitLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaGridLayout.TAG_NAME.equals(tagName) ) {
			MetaGridLayout layout = new MetaGridLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaTableLayout.TAG_NAME.equals(tagName) ) {
			MetaTableLayout layout = new MetaTableLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaFluidTableLayout.TAG_NAME.equals(tagName) ) {
			MetaFluidTableLayout layout = new MetaFluidTableLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaLinearLayout.TAG_NAME.equals(tagName) ){
			MetaLinearLayout layout = new MetaLinearLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		} else if ( MetaComponentOverrides.TAG_NAME.equals(tagName) ) {
			overrides = new MetaComponentOverrides();
			overrides.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = overrides;
		} else if ( MetaTableViewLayout.TAG_NAME.equals(tagName)){
			MetaTableViewLayout layout = new MetaTableViewLayout();
			layout.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = layout;
			add(layout);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaComponentView newObject = (MetaComponentView)super.clone();
		newObject.setKey(key);
		newObject.setOverrides(overrides == null ? null : (MetaBaseComponentOverrides)overrides.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaComponentView();
	}

	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置覆盖
	 * @param overrides 覆盖
	 */
	public void setOverrides(MetaBaseComponentOverrides overrides) {
		this.overrides = overrides;
	}
	
	/**
	 * 取得覆盖
	 * @return 覆盖
	 */
	public MetaBaseComponentOverrides getOverrides() {
		return this.overrides;
	}
}
