package com.bokesoft.yigo.meta.form.component.panel.gridpanel;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaRowDefCollection extends GenericNoKeyCollection<MetaRowDef> {
	public static final String TAG_NAME = "RowDefCollection";
	/** 默认行高 */
	private Integer rowHeight = 0;
	/** 行间隔 */
	private Integer rowGap = 0;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		MetaRowDef metaRowDef = null;
		if (MetaRowDef.TAG_NAME.equalsIgnoreCase(tagName)) {
			metaRowDef = new MetaRowDef();
			this.add(metaRowDef);
		}
		return metaRowDef;
	}

	/**
	 * 设置默认行高
	 * 
	 * @param rowHeight
	 *            行高
	 */
	public void setRowHeight(Integer rowHeight) {
		this.rowHeight = rowHeight;
	}

	/**
	 * 取得默认行高
	 * 
	 * @return 行高
	 */
	public Integer getRowHeight() {
		return rowHeight;
	}

	/**
	 * 设置行间隔
	 * 
	 * @param rowGap
	 *            行间隔
	 */
	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}

	/**
	 * 取得行间隔
	 * 
	 * @return 行间隔
	 */
	public Integer getRowGap() {
		return rowGap;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaRowDefCollection newObject = (MetaRowDefCollection)super.clone();
		newObject.setRowHeight(rowHeight);
		newObject.setRowGap(rowGap);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRowDefCollection();
	}
}
