package com.bokesoft.yigo.meta.form.component.panel.flexgridpanel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;

public class MetaFlexGridLayoutPanel extends MetaPanel{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/** 列数 */
	private Integer columnCount = 1;
	/** 列间距 */
	private Integer columnGap = 0;
	/** 行间距 */
	private Integer rowGap = 0;
	/** 行高 */
	private Integer rowHeight = 30;
	
	public static final String TAG_NAME = ControlType.STR_FLEXGRIDLAYOUTPANEL;
	

	public Integer getColumnCount() {
		return columnCount;
	}

	public void setColumnCount(Integer columnCount) {
		this.columnCount = columnCount;
	}

	public Integer getColumnGap() {
		return columnGap;
	}

	public void setColumnGap(Integer columnGap) {
		this.columnGap = columnGap;
	}

	public Integer getRowGap() {
		return rowGap;
	}

	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}

	public Integer getRowHeight() {
		return rowHeight;
	}

	public void setRowHeight(Integer rowHeight) {
		this.rowHeight = rowHeight;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public MetaFlexGridLayout newLayout() {
		MetaFlexGridLayout layout = new MetaFlexGridLayout();
		layout.setKey(key);
		layout.setColumnCount(columnCount);
		layout.setColumnGap(columnGap);
		layout.setRowGap(rowGap);
		layout.setRowHeight(rowHeight);
		
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutSpan item = new MetaLayoutSpan();
			item.setKey(metaComponent.getKey());
			item.setXSpan(metaComponent.getXSpan());
			item.setYSpan(metaComponent.getYSpan());
			layout.add(item);
		}
		
		return layout;
	}

	@Override
	public int getControlType() {
		return ControlType.FLEXGRIDLAYOUTPANEL;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFlexGridLayoutPanel();
	}
	
	@Override
	public void merge(MetaComponent meta){
		super.merge(meta);
		
		MetaFlexGridLayoutPanel metaPanel = (MetaFlexGridLayoutPanel) meta;
		if(this.columnCount == -1){
			this.columnCount = metaPanel.getColumnCount();
		}
		if(this.columnGap == -1){
			this.columnGap = metaPanel.getColumnGap();
		}
		if(this.rowGap == -1){
			this.rowGap = metaPanel.getRowGap();
		}
		if(this.rowHeight == -1){
			this.rowHeight = metaPanel.getRowHeight();
		}
	}

}
