package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutWizardItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaWizardLayout;

public class MetaWizardPanel extends MetaPanel {
	public static final String TAG_NAME = ControlType.STR_WIZARDPANEL;
	/** 导航提示相对分页栏的位置（上、下、左、右） */
	private Integer wizardPosition = DirectionType.TOP;
	/** 结束事件 */
	private MetaBaseScript finish = null;
	

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 取得导航提示位置
	 * @return 导航提示位置
	 */
	public Integer getWizardPosition() {
		return this.wizardPosition;
	}

	/**
	 * 设置导航提示位置
	 * @param wizardPosition 导航提示位置
	 */
	public void setWizardPosition(Integer wizardPosition) {
		this.wizardPosition = wizardPosition;
	}

	/**
	 * 取得完成事件
	 * @return 事件
	 */
	public MetaBaseScript getFinish() {
		return finish;
	}

	/**
	 * 设置完成事件
	 * @param finish 事件
	 */
	public void setFinish(MetaBaseScript finish) {
		this.finish = finish;
	}

	@Override
	public int getControlType() {
		return ControlType.WIZARDPANEL;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if( finish != null ) {
			list.add(finish);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {

		if( tagName.equalsIgnoreCase(MetaConstants.Event_Finish)) {
			finish = new MetaBaseScript(MetaConstants.Event_Finish);
			return finish;
		}
		return super.createChildMetaObject(env, doc, node, tagName, flag, runType);
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaWizardPanel newObject = (MetaWizardPanel)super.clone();
		newObject.setWizardPosition(wizardPosition);
		newObject.setFinish(finish == null ? null : (MetaBaseScript)finish.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWizardPanel();
	}
	
	/**
	 * 从多栏布局面板中生成多栏布局
	 * @return 多栏布局
	 */
	@Override
	public MetaWizardLayout newLayout() {
		MetaWizardLayout layout = new MetaWizardLayout();
		layout.setKey(key);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutWizardItem item = new MetaLayoutWizardItem();
			item.setKey(metaComponent.getKey());
			item.setCaption(metaComponent.getCaption());
			layout.add(item);
		}
		return layout;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

}
