package com.bokesoft.yigo.meta.form.component.i18n;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaI18n定义显示文字的多语种字符串表
 * <pre>
 * &lt;i18n&gt;
 *  &lt;zh-CN&gt;&lt;/zh-CN&gt;
 *  &lt;en-US&gt;&lt;/en-US&gt;
 *  ...
 * &lt;/i18n&gt;
 * </pre>
 */
public class MetaI18n extends GenericNoKeyCollection<MetaI18nItem>{
	
	public static final String TAG_NAME = "i18n";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		
		MetaI18nItem item = new MetaI18nItem();
		item.setKey(tagName);
		this.add(item);
		return item;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaI18n();
	}
}
