package com.bokesoft.yigo.meta.form.component.html;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

public class MetaHtml_LI extends MetaHtmlElement {
	/** 列表项文本 */
	private String text = "";
	/** 内嵌组件 */
	private MetaComponent component = null;
	
	public MetaHtml_LI() {
		super();
	}
	
	public void setText(String text) {
		this.text = text;
	}
	
	public String getText() {
		return this.text;
	}
	
	public void setComponent(MetaComponent component) {
		this.component = component;
	}
	
	public MetaComponent getComponent() {
		return this.component;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( component != null ) {
			list.add(component);
		}
	}

	public static final String TAG_NAME = ControlType.STR_HTML_ELEMENT_LI;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		component = MetaComponentFactory.getInstance().newComponent(tagName);
		resultMetaObject = component;
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaHtml_LI newObject = new MetaHtml_LI();
		newObject.setText(text);
		newObject.setComponent(component == null ? null : (MetaComponent)component.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHtml_LI();
	}

	@Override
	public int getControlType() {
		return ControlType.HTML_ELEMENT_LI;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

}
