package com.bokesoft.yigo.meta.form.component.grid.dynamic;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaCellTypeTable extends GenericKeyCollection<MetaCellTypeGroup> implements IElementMerge<MetaCellTypeTable>{
	
	public static final String TAG_NAME = "CellTypeTable";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if( MetaCellTypeGroup.TAG_NAME.equals(tagName) ) {
			MetaCellTypeGroup group = new MetaCellTypeGroup();
			group.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(group);
			metaObject = group;
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCellTypeTable();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		Iterator<MetaCellTypeGroup> it = iterator();
		while( it.hasNext() ) {
			MetaCellTypeGroup group = it.next();
			group.doPostProcess(flag, callback);
		}
	}
	
	/**
	 * 合并
	 * @param cellTypeTable 需要被合并的单元格类型表
	 */
	public void merge(MetaCellTypeTable cellTypeTable) {
		Iterator<MetaCellTypeGroup> it = cellTypeTable.iterator();
		while( it.hasNext() ) {
			this.add(it.next());
		}
	}

	@Override
	public MetaCellTypeTable toMerge(MetaCellTypeTable obj) {
		if (obj != null) {
			merge(obj);
		}
		return this;
	}
}
