package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.AppEventType;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FilterOptSign;
import com.bokesoft.yigo.common.def.FilterValueType;
import com.bokesoft.yigo.meta.base.*;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import org.apache.commons.lang3.StringUtils;

public class MetaGridFilter extends GenericKeyCollection<MetaFilterValue> {

	private List<String> dependentFields = new ArrayList<String>();

	public static final String TAG_NAME = "GridFilter";

	/** 过滤条件依赖的组件的集合*/
	private String filterDependency = "";

	/** 运算符 */
	private Integer optSign = FilterOptSign.AND;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
//		list.add(this.elementArray);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaFilterValue.TAG_NAME.equals(tagName) ) {
			MetaFilterValue fieldValue = new MetaFilterValue();
			fieldValue.preProcessMetaObject(env, doc, node, flag, runType);
			if (runType == AppRunType.Dev){
				int i = 1;
				if (StringUtils.isEmpty(fieldValue.getKey())){
					fieldValue.setKey(String.valueOf(i));
				}
				while (this.containsKey(fieldValue.getKey())){
					fieldValue.setKey(String.valueOf(i));
					i++;
				}
			}
			this.add(fieldValue);
			resultMetaObject = fieldValue;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridFilter();
	}

	/**
	 * 设置参数的连接运算符
	 * @return 参数的连接运算符
	 */
	public Integer getOptSign() {
		return optSign;
	}

	/**
	 * 设置参数的连接运算符
	 * @param optSign 参数的连接运算符
	 */
	public void setOptSign(Integer optSign) {
		this.optSign = optSign;
	}

	/**
	 * 获取依赖集合
	 * @return 依赖集合
	 */
	public List<String> getDependentFields() {
		return dependentFields;
	}

	/**
	 * 获取过滤依赖的组件集合
	 * @return 依赖集合的字符串表示
	 */
	public String getFilterDependency() {
		return filterDependency;
	}

	/**
	 * 设置依赖字段定义
	 * @param dependency 依赖字段定义，以,分隔，比如[A,B]
	 */
	public void setFilterDependency(String dependency){
		this.filterDependency = dependency;

		if(dependency != null && dependency.length() > 0){
			String[] fields = this.filterDependency.split(",");
			for(String field : fields){
				dependentFields.add(field);
			}
		}
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		Iterator<MetaFilterValue> it = this.iterator();
		while( it.hasNext() ) {
			MetaFilterValue filterValue = it.next();
			if( filterValue.getType() == FilterValueType.FIELD ){
				String refValKey = filterValue.getRefValueKey();
				if( !refValKey.isEmpty() && !this.dependentFields.contains(refValKey) ) {
					this.dependentFields.add(refValKey);
				}
			}
		}
	}


	@Override
	public AbstractMetaObject clone() {
		MetaGridFilter newObject = (MetaGridFilter) super.clone();
		newObject.setFilterDependency(this.filterDependency);
		newObject.setOptSign(this.optSign);
		return newObject;
	}
	public List<MetaFilterValue> getList() {
		List<MetaFilterValue> list = new ArrayList<>(elementMap.values());
		return list;
	}
}
