package com.bokesoft.yigo.meta.form.component.control.treeview;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBarCoderProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNoticeBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRelativeTimeProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;

/**
 * MetaTreeViewColumn定义TreeView控件中列的描述，包括列的标识、名称、列宽和列的数据来源。
 * @author 王元和
 */
public class MetaTreeViewColumn extends KeyPairMetaObject {
	/** 列的标识 */
	private String key = "";
	/** 列的名称 */
	private String caption = "";
	/** 
	 * 列宽，取值只能是固定值(px)或者比例值(%)来描述 
	 * @see DefSize
	 */
	private DefSize width = null;
	/** 数据绑定的表 */
	private String tableKey = "";
	/** 列绑定的数据源中的列标识 */
	private String dataColumnKey = "";
	/** 列的控件类型 */
	private Integer columnType = ControlType.LABEL;
	private AbstractMetaObject properties = null;
	
	public MetaTreeViewColumn() {
		super();
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = properties;
	}
	
	public AbstractMetaObject getProperties() {
		if( properties == null ){
			ensureProperties();
		}
		return this.properties;
	}
	
	public void ensureProperties() {
		if ( properties == null ) {
			switch ( columnType ) {
			case ControlType.LABEL:
				this.properties = new MetaLabelProperties();
				break;
			case ControlType.PRICELABEL:
				this.properties = new MetaPriceLabelProperties();
				break;
			case ControlType.RELATIVETIME:
				this.properties = new MetaRelativeTimeProperties();
				break;
			case ControlType.CHECKBOX:
				this.properties = new MetaCheckBoxProperties();
				break;
			case ControlType.HYPERLINK:
				this.properties = new MetaHyperLinkProperties();
				break;
			case ControlType.BUTTON:
				this.properties = new MetaButtonProperties();
				break;
			case ControlType.NOTICEBAR:
				this.properties = new MetaNoticeBarProperties();
				break;
			case ControlType.BARCODER:
				this.properties = new MetaBarCoderProperties();
				break;
			case ControlType.TOGGLEBUTTON:
				this.properties = new MetaToggleButtonProperties();
				break;
			case ControlType.MULTISTATEBUTTON:
				this.properties = new MetaMultiStateButtonProperties();
				break;
			case ControlType.DATEPICKER:
				this.properties = new MetaDatePickerProperties();
				break;
			case ControlType.DICT:
				this.properties = new MetaDictProperties();
				break;
			case ControlType.NUMBEREDITOR:
				this.properties = new MetaNumberEditorProperties();
				break;
			case ControlType.TEXTEDITOR:
				this.properties = new MetaTextEditorProperties();
				break;
			default:
				throw new RuntimeException("treeview 中 不支持的控件类型:"
						+ ControlType.toString(columnType));
			}
		}
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( this.properties != null ) {
			this.properties.getChildMetaObjects(list);
		}
	}

	public static final String TAG_NAME = "TreeViewColumn";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( this.properties != null ) {
			resultMetaObject = properties.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	/**
	 * 设置列标识
	 * @param key 列标识
	 * @see #key
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得列标识
	 * @return 列标识
	 * @see #key
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置列名称
	 * @param caption 列名称
	 * @see #caption
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得列名称
	 * @return 列名称
	 * @see #caption
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置列宽
	 * @param width 列宽
	 * @see #width
	 */
	public void setWidth(DefSize width) {
		this.width = width;
	}
	
	/**
	 * 取得列宽
	 * @return 列宽
	 * @see #width
	 */
	public DefSize getWidth() {
		return this.width;
	}
	
	/**
	 * 设置数据绑定的表
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得数据绑定的表
	 * @return 表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}
	
	/**
	 * 设置列绑定的数据源列标识
	 * @param dataColumnKey 数据源列标识
	 * @see #dataColumnKey
	 */
	public void setDataColumnKey(String dataColumnKey) {
		this.dataColumnKey = dataColumnKey;
	}
	
	/**
	 * 取得列绑定的数据源列标识
	 * @return 数据源列标识
	 * @see #dataColumnKey
	 */
	public String getDataColumnKey() {
		return this.dataColumnKey;
	}
	
	/**
	 * 设置列的控件类型
	 * @param columnType 控件类型
	 */
	public void setColumnType(Integer columnType) {
		this.columnType = columnType;
	}
	
	/**
	 * 取得列的控件类型
	 * @return 控件类型
	 */
	public Integer getColumnType() {
		return this.columnType;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTreeViewColumn newObject = new MetaTreeViewColumn();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setWidth(width);
		newObject.setTableKey(tableKey);
		newObject.setDataColumnKey(dataColumnKey);
		newObject.setColumnType(columnType);
		newObject.setProperties(properties == null ? null : properties.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTreeViewColumn();
	}
	
	@Override
	public boolean needPreLoad() {
		return false;
	}
	
}
