package com.bokesoft.yigo.meta.form.component.control.shrinkview;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

public class MetaToolBarExpand extends AbstractMetaObject {
	public static final String TAG_NAME = "ToolBarExpand";

	private MetaComponent root;

	public MetaComponent getRoot() {
		return root;
	}

	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (root != null)
			list.add(root);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultObj = MetaComponentFactory.getInstance().newComponent(tagName);
		if (resultObj != null) {
			root = (MetaComponent) resultObj;
			root.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultObj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaToolBarExpand meta = (MetaToolBarExpand) newInstance();
		meta.setRoot(root == null ? null : (MetaComponent) root.clone());
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaToolBarExpand();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (root != null)
			root.doPostProcess(flag, callback);
	}
}
