package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaTimePickerProperties extends AbstractMetaObject implements IPropertyMerger<MetaTimePickerProperties>{
	/** 默认日期时间的显示格式 */
	private String dateFormat = null;
	
	private static String SHORT_FORMAT = "HH:mm";
	
	private static String LONG_FORMAT = "HH:mm:ss";
	
	/** 文本编辑器为空时的提示信息 */
	private String promptText = "";
	
	private Boolean isSecond = false;
	
	/** 编辑样式*/
	private Integer editType = SelectEditType.POP;
	
	public void setDateFormat(String dateFormat){
		this.dateFormat = dateFormat;
	}
	
	public String getDateFormat() {
		return this.dateFormat;
	}

	public String getPromptText() {
		return promptText;
	}


	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}


	public Integer getEditType() {
		return editType;
	}


	public void setEditType(Integer editType) {
		this.editType = editType;
	}

	
	public void setSecond(Boolean isSecond) {
		this.isSecond = isSecond;
	}
	
	public Boolean isSecond(){
		return this.isSecond;
	}

	@Override
	public void merge(MetaTimePickerProperties properties) {
		if( this.dateFormat == null ){
			this.dateFormat = properties.getDateFormat();
		}
		if( this.isSecond == null ){
			this.isSecond = properties.isSecond();
		}
		if( this.promptText == null ){
			this.promptText = properties.getPromptText();
		}
		
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTimePickerProperties newObject = new MetaTimePickerProperties();
		newObject.setDateFormat(dateFormat);
		newObject.setSecond(isSecond);
		newObject.setPromptText(promptText);
		newObject.setEditType(editType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTimePickerProperties();
	}

}
