package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaStateListProperties extends AbstractMetaObject {
	/** 方位 */
	private int orientation = OrientationType.Horizontal;
	/** 状态列表 */
	private MetaStateItemCollection items = null;
	
	public MetaStateListProperties() {
		super();
		this.items = new MetaStateItemCollection();
	}
	
	/**
	 * 设置方位
	 * @param orientation 方位
	 */
	public void setOrientation(int orientation) {
		this.orientation = orientation;
	}
	
	/**
	 * 取得方位
	 * @return 方位
	 */
	public int getOrientation() {
		return this.orientation;
	}
	
	/**
	 * 设置状态列表
	 * @param items 状态列表
	 */
	public void setItems(MetaStateItemCollection items) {
		this.items = items;
	}
	
	/**
	 * 取得状态列表
	 * @return 状态列表
	 */
	public MetaStateItemCollection getItems() {
		return this.items;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = items.createChildMetaObject(env, doc, node, tagName, flag, runType);
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStateListProperties newObject = (MetaStateListProperties)newInstance();
		newObject.setItems(items == null ? null : (MetaStateItemCollection)items.clone());
		newObject.setOrientation(orientation);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStateListProperties();
	}
}
