package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaSplitButtonProperties extends AbstractMetaObject {
	/** 点击事件 */
	private MetaBaseScript onClick = null;
	/** 按钮图标 */
	private String icon = "";
	/** 下拉项集合 */
	private MetaDropdownItemCollection itemCollection = new MetaDropdownItemCollection();
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( onClick != null ) {
			list.add(onClick);
		}
		if ( itemCollection != null ) {
			list.add(itemCollection);
		}
	}
	
	/**
	 * 设置点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}
	
	/**
	 * 取得点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}
	
	/**
	 * 设置图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.icon;
	}
	
	/**
	 * 设置下拉项集合
	 * @param itemCollection 下拉项集合
	 */
	public void setItemCollection(MetaDropdownItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	/**
	 * 取得下拉项集合
	 * @return 下拉项集合
	 */
	public MetaDropdownItemCollection getItemCollection() {
		return this.itemCollection;
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = this.itemCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( MetaConstants.Event_OnClick.equals(tagName) ) {
				onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
				resultMetaObject = onClick;
			}
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSplitButtonProperties newObject = new MetaSplitButtonProperties();
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setIcon(icon);
		newObject.setItemCollection(itemCollection == null ? null : (MetaDropdownItemCollection)itemCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSplitButtonProperties();
	}
}
