package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaRelativeTimeProperties extends AbstractMetaObject
		implements IPropertyMerger<MetaRelativeTimeProperties> {

	/** 自动更新时间，单位秒 */
	private Integer interval = 60;

	/**
	 * 设置自动更新时间
	 * 
	 * @param interval
	 *            自动更新时间
	 */
	public void setInterval(Integer interval) {
		this.interval = interval;
	}

	/**
	 * 获取自动更新时间
	 * 
	 * @return 自动更新时间
	 */
	public Integer getInterval() {
		return interval;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRelativeTimeProperties newObject = new MetaRelativeTimeProperties();
		newObject.setInterval(interval);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelativeTimeProperties();
	}

	@Override
	public void merge(MetaRelativeTimeProperties properties) {
		if (this.interval == -1) {
			this.interval = properties.getInterval();
		}
	}
}
