package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaPriceLabelProperties extends AbstractMetaObject implements IPropertyMerger<MetaPriceLabelProperties> {

	/** 前置文本，通常是货币符号 */
	private String preText = "";
	/** 小数位数 */
	private Integer decimalDigits = 2;
	/** 是否显示千分位 */
	private Boolean showThousandth = true;
	/** 定义格式化部分的项的集合*/
	private MetaPriceLabelItemCollection itemCollection = new MetaPriceLabelItemCollection();

	/**
	 * 获取前置文本
	 * @return 前置文本
	 */
	public String getPreText() {
		return preText;
	}

	/**
	 * 设置前置文本
	 * @param preText 前置文本
	 */
	public void setPreText(String preText) {
		this.preText = preText;
	}

	/**
	 * 获取小数位数
	 * @return 小数位数
	 */
	public Integer getDecimalDigits() {
		return decimalDigits;
	}

	/**
	 * 设置小数位数
	 * @param decimalDigits 小数位数
	 */
	public void setDecimalDigits(Integer decimalDigits) {
		this.decimalDigits = decimalDigits;
	}

	/**
	 * 获取是否显示千分位
	 * @return 是否显示千分位
	 */
	public Boolean getShowThousandth() {
		return showThousandth;
	}

	/**
	 * 设置是否显示千分位
	 * @param showThousandth 是否显示千分位
	 */
	public void setShowThousandth(Boolean showThousandth) {
		this.showThousandth = showThousandth;
	}
	
	/**
	 * 获取定义格式化部分的项的集合
	 * @return 定义格式化部分的项的集合
	 */
	public MetaPriceLabelItemCollection getItemCollection() {
		return itemCollection;
	}
	
	/**
	 * 设置定义格式化部分的项的集合
	 * @param itemCollection 定义格式化部分的项的集合
	 */
	public void setItemCollection(MetaPriceLabelItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list,new AbstractMetaObject[]{itemCollection});
	}

	@Override
	public String getTagName() {
		return null;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = itemCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPriceLabelProperties newObject = (MetaPriceLabelProperties)newInstance();
		newObject.setPreText(preText);
		newObject.setDecimalDigits(decimalDigits);
		newObject.setShowThousandth(showThousandth);
		newObject.setItemCollection(itemCollection == null ? null : (MetaPriceLabelItemCollection)itemCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPriceLabelProperties();
	}

	@Override
	public void merge(MetaPriceLabelProperties properties) {
		if(preText == null){
			this.preText = properties.getPreText();
		}
		if(decimalDigits == -1){
			this.decimalDigits = properties.getDecimalDigits();
		}
		if(showThousandth == null){
			this.showThousandth = properties.getShowThousandth();
		}
	}
}
