package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.PopButtonLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

/**
 * 弹出视图按钮的属性对象，包含具体属性
 */
public class MetaPopButtonProperties extends MetaButtonProperties{

	/** 弹出视图的方位*/
	private Integer location = PopButtonLocationType.LEFT;

	/** 弹出视图的根组件*/
	private MetaComponent root;

	/**
	 * 获取弹出视图的方位
	 * @return 弹出视图的方位
	 */
	public Integer getLocation() {
		return location;
	}

	/**
	 * 设置弹出视图的方位
	 * @param location 弹出视图的方位
	 */
	public void setLocation(Integer location) {
		this.location = location;
	}

	/**
	 * 获取弹出视图的根组件
	 * @return 弹出视图的根组件
	 */
	public MetaComponent getRoot() {
		return root;
	}

	/**
	 * 设置弹出视图的根组件
	 * @param root 弹出视图的根组件
	 */
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if (root != null) {
			list.add(root);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (metaObject == null) {
			root = MetaComponentFactory.getInstance().newComponent(tagName);
			root.preProcessMetaObject(env, doc, node, flag, runType);
			metaObject = root;
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPopButtonProperties metaObject = (MetaPopButtonProperties) super.clone();
		metaObject.setLocation(location);
		metaObject.setRoot(root);
		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPopButtonProperties();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (root != null) {
			root.doPostProcess(flag, callback);
		}
	}
	
	@Override
	public void merge(MetaButtonProperties popButtonProperties) {
		super.merge(popButtonProperties);
		MetaPopButtonProperties popProperties = (MetaPopButtonProperties)popButtonProperties;
		if(location == -1){
			this.location = popProperties.getLocation();
		}
		if(root == null){
			this.root = popProperties.getRoot();
		}
	}
}
