package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * 数值信息输入框组件的属性对象
 * @author chenzs
 *
 */
public class MetaNumberInfoEditorProperties extends AbstractMetaObject implements IPropertyMerger<MetaNumberInfoEditorProperties>{

	/** 数值格式化字符串，比如设置为%%-%%%%%%%%，显示为021-60190088，其中%是固定的替换符号，不允许改为其他值*/
	private String format = "";
	/** 软键盘的回车键类型*/
	private Integer imeOptions = -1;
	/** 焦点获取事件*/
	private MetaBaseScript onFocus = null;
	/** 是否禁用软键盘，针对带有输入框的组件*/
	private Boolean disableKeyboard;
	
	/**
	 * 获取数值格式化字符串，比如设置为%%-%%%%%%%%，显示为021-60190088，其中%是固定的替换符号，不允许改为其他值
	 * @return 数值格式化字符串
	 */
	public String getEditorFormat() {
		return format;
	}

	/**
	 * 设置数值格式化字符串，比如设置为%%-%%%%%%%%，显示为021-60190088，其中%是固定的替换符号，不允许改为其他值
	 * @param format 数值格式化字符串
	 */
	public void setEditorFormat(String format) {
		this.format = format;
	}

	/**
	 * 获取软键盘的回车类型
	 * @return 软键盘的回车类型,参考{@link com.bokesoft.yigo.common.def.EditorImeOptions}
	 */
	public Integer getImeOptions() {
		return imeOptions;
	}

	/**
	 * 设置软键盘的回车类型
	 * @param imeOptions 软键盘的回车类型,参考{@link com.bokesoft.yigo.common.def.EditorImeOptions}
	 */
	public void setImeOptions(Integer imeOptions) {
		this.imeOptions = imeOptions;
	}

	/**
	 * 获取焦点获取事件
	 * @return 焦点获取事件
	 */
	public MetaBaseScript getOnFocus() {
		return onFocus;
	}

	/**
	 * 设置焦点获取事件
	 * @param onFocus 焦点获取事件
	 */
	public void setOnFocus(MetaBaseScript onFocus) {
		this.onFocus = onFocus;
	}

	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.disableKeyboard = disableKeyboard;
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return disableKeyboard;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(onFocus);
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnFocus.equals(tagName) ) {
			this.onFocus = new MetaBaseScript(MetaConstants.Event_OnFocus);
			resultMetaObject = this.onFocus;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNumberInfoEditorProperties newObj = (MetaNumberInfoEditorProperties) newInstance();
		newObj.setEditorFormat(format);
		newObj.setImeOptions(imeOptions);
		newObj.setOnFocus(onFocus == null ? null : (MetaBaseScript)onFocus.clone());
		newObj.setDisableKeyboard(disableKeyboard);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNumberInfoEditorProperties();
	}
	
	@Override
	public void merge(MetaNumberInfoEditorProperties properties) {
		if(format == null){
			format = properties.getEditorFormat();
		}
		if(imeOptions == -1){
			imeOptions = properties.getImeOptions();
		}
		if(onFocus == null){
			onFocus = properties.getOnFocus();
		}
		if(disableKeyboard == null){
			disableKeyboard = properties.isDisableKeyboard();
		}
	}
}
