package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.*;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import org.apache.commons.lang3.StringUtils;

public class MetaItemFilter extends GenericKeyCollectionWithKey<MetaFilter> implements IPropertyMerger<MetaItemFilter> {
	/** 对应字典的ItemKey*/
	private String itemKey = "";

	public MetaItemFilter() {
		super();
	}


	@Override
	public String getKey() {
		return itemKey;
	}

	@Override
	public void setKey(String key) {
		this.itemKey = key;
	}
	public void setItemKey(String itemKey){
		this.itemKey = itemKey;
	}

	public String getItemKey(){
		return this.itemKey;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "ItemFilter";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaFilter.TAG_NAME.equals(tagName) ) {
			MetaFilter filter = new MetaFilter();
			filter.preProcessMetaObject(env, doc, node, flag, runType);
			if (runType == AppRunType.Dev){
				int i = 1;
				if (StringUtils.isEmpty(filter.getKey())){
					filter.setKey("F"+i+"_Filter");
				}
				while (this.containsKey(filter.getKey())){
					filter.setKey("F"+i+"_Filter");
					i++;
				}
			}
			this.add(filter);
			resultMetaObject = filter;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaItemFilter newObject = (MetaItemFilter) super.clone();
		newObject.setItemKey(this.itemKey);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaItemFilter();
	}
	public boolean isEmpty() {
		synchronized(elementMap) {
			return elementMap.isEmpty();
		}
	}
	public MetaFilter get(int index) {
		synchronized(elementMap) {
			return (MetaFilter) elementMap.values().toArray()[index];
		}
	}
	public List<MetaFilter> getList() {
		List<MetaFilter> list = new ArrayList(elementMap.values());
		return list;
	}
	@Override
	public void merge(MetaItemFilter metaFilters) {
		if (metaFilters.size() > 0){
			for (MetaFilter metaFilter : metaFilters) {
				if (this.containsKey(metaFilter.getKey())){
					this.get(metaFilter.getKey()).merge(metaFilter);
				} else {
					this.add(metaFilter);
				}
			}
		}
	}
}
