package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * GIF动图组件属性对象
 * @author chenzs
 *
 */
public class MetaGIFImageProperties extends AbstractMetaObject implements IPropertyMerger<MetaGIFImageProperties>{

	/** 动图来源类型，默认为Data */
	private Integer sourceType  = ImageSourceType.DATA;
	
	/** 在类型为Resource时的相对路径，定义图片来源*/
	private String image = "";
	
	/** 鼠标点击事件 */
	private MetaBaseScript onClick = null;
	
	/** 拉伸缩放类型*/
	private Integer imageScaleType = -1;
	
	/**
	 * 获取来源类型
	 * @return 来源类型，参考{@link com.bokesoft.yigo.common.def.ImageSourceType}
	 */
	public Integer getSourceType() {
		return sourceType;
	}
	
	/**
	 * 设置来源类型
	 * @param sourceType 来源类型，参考{@link com.bokesoft.yigo.common.def.ImageSourceType}
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 获取在类型为Resource时定义图片来源的相对路径
	 * @return 在类型为Resource时定义图片来源的相对路径
	 */
	public String getImage() {
		return image;
	}

	/**
	 * 设置在类型为Resource时定义图片来源的相对路径
	 * @param image 在类型为Resource时定义图片来源的相对路径
	 */
	public void setImage(String image) {
		this.image = image;
	}
	
	/**
	 * 获取点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return onClick;
	}

	/**
	 * 设置点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}
	
	/**
	 * 设置图片拉伸缩放类型
	 * @param imageScaleType 拉伸缩放类型
	 */
	public void setImageScaleType(Integer imageScaleType) {
		this.imageScaleType = imageScaleType;
	}
	
	
	/**
	 * 获取图片拉伸缩放类型
	 * @return 拉伸缩放类型
	 */
	public Integer getImageScaleType() {
		return imageScaleType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[]{onClick});
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject result = null;
		if(MetaConstants.Event_OnClick.equals(tagName)){
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			result = onClick;
		}
		return result;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGIFImageProperties newObj = new MetaGIFImageProperties();
		newObj.setSourceType(sourceType);
		newObj.setImage(image);
		newObj.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObj.setImageScaleType(imageScaleType);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGIFImageProperties();
	}

	@Override
	public void merge(MetaGIFImageProperties properties) {
		if(sourceType == -1){
			sourceType = properties.getSourceType();
		}
		if(image == null){
			image = properties.getImage();
		}
		if(onClick == null){
			onClick = properties.getOnClick();
		}
		
	}
}
